/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.common;

/**
 * This interface is the model of a generic sensor.
 * It can juste return a value and update it.
 * @author virieux
 */
public interface Sensor {

    /**
     * 
     * @return the field value for the object Sensor
     */
    int getValue();
    
    /**
     * This method reads the current value measured by the hardware 
     * or compute a random value for the simulated sensor, and returns this
     * current value.
     * @return the current value provided by the real or simulated sensor. 
     */
    int readNewValue();
    
    /**
     * This method reads the current value, controls if this current value 
     * is correct depending on the type of the sensor (this value could 
     * be between a minimum and a maximum) and if the value is correct, updates the
     * Sensor.value field.
     * 
     */
    void updateValue();


}
