package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;

/**
 * This is a model for the Latch which holds a filter on an autochanger's truck.
 * There is 2 trucks on the autochanger, so there is 2 latches : LatchX- and LatchX+
 * @author virieux
 */
public interface Latch {

    
	public String unlock() throws BadCommandException, ErrorInCommandExecutionException;
	
	public String lock() throws BadCommandException, ErrorInCommandExecutionException;;

	public boolean isLocked();
        
        public boolean isUnlocked();
        
        public boolean isInError();

}
