package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;


public interface FilterClamp {

    /**
    * @return the filterPresence
    */
    public Sensor getFilterPresenceSensor();

    public boolean isLocked();

    public void setState(FilterClampState state);
    public FilterClampState getState();

    public String release(Actuator actuator) throws BadCommandException, ErrorInCommandExecutionException;

    public String unlock(Actuator actuator) throws BadCommandException, ErrorInCommandExecutionException;

    //public String lock(Actuator actuator) throws BadCommandException, ErrorInCommandExecutionException;

    public void updateStateWithSensors();

    public String getName();

    public int getTickMillis();

    public StatusDataPublishedByClamp getStatusData();

    public boolean isFilterEngaged();

   
    



       
}
