/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.common;


import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;

/**
 * The ClampOnFilterState for a clamp is when the clamp
 * is locked on a filter.
 * @author virieux
 */
class ClampedOnFilter implements FilterClampState {

    @Override
    public String toString() {
        return "CLAMPED ON FILTER";
    }

    //TODO if we have to do the same thing to unlock a clamp
    //when a filter is there or not, we'll have to refactor the code
    //with only 2 clamp states : CLAMPED or UNCLAMPED
    @Override
    @SuppressWarnings("SleepWhileHoldingLock")
    public String unlock(FilterClamp clamp) throws ErrorInCommandExecutionException {
        //TODO : there must be a timeout
        while (clamp.isLocked()) {

            try {
                Thread.sleep(clamp.getTickMillis());
            } catch (InterruptedException ex) {
                //Logger.getLogger(ReadyToClampState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        if (!clamp.isLocked()) {
            clamp.setState((FilterClampState) UNCLAMPEDONFILTER);
            return clamp.getName() + " is unlocked";
        }

        throw new ErrorInCommandExecutionException(clamp.getName() + " couldn't be unlocked.");
    }

    @Override
    public String release(FilterClamp filterClamp) {
        throw new UnsupportedOperationException("Not supported : can't release a clamp in state " + toString());
    }

    @Override
    public String lock(FilterClamp filterClamp) {
        throw new UnsupportedOperationException("The clamp is already locked.");
    }

}
