package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;

public interface AutoChanger {
			
	public String goToPosition(double trucksPositionOnline) throws BadCommandException;

	public String stop();

	public double getTrucksPosition();

	public Filter getFilterOnTrucks();

	public String moveFilterToOnline(Filter filter) throws BadCommandException, ErrorInCommandExecutionException;
	
	public String moveFilterToStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException;
	
	public String grabbeFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException;

	public String unGrabbeFilterAtStandby() throws BadCommandException, ErrorInCommandExecutionException;

	public String lockLatchesAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException;
	
	public String unlockLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException;

	public void locateTrucks();

	public void initPublishedData();
	
}
