/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

/**
 * 
 * A structure for the data published on the status bus by the ClampModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByClamp {

    private String name;
    private String state;
    private String filterPresenceSensorState;
    private int filterSensorValue;

    public StatusDataPublishedByClamp() {
        name = "fake clamp";
        state = "unknown";
        filterPresenceSensorState = "0";
        filterSensorValue = 0;
    }
    

    public void update(FilterClampModule clamp) {
        name = clamp.getName();
        state = clamp.getState().toString();       
        filterPresenceSensorState = clamp.getFilterPresenceSensor().toString();
        filterSensorValue = clamp.getFilterPresenceSensor().getValue();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("clamp ");
        sb.append(name).append(" is in state ").append(state);    
        sb.append(" / filter presence sensor value= ").append(filterSensorValue);
        return sb.toString();
    }

}
