/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 * 
 * A structure for the data published on the status bus by a BasicAutoChangerModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByBasicAutoChanger implements Serializable {

    private static final long serialVersionUID = 1L;
	private String filterOnTrucksName;
        private boolean isEmpty;

    public StatusDataPublishedByBasicAutoChanger() {
        super();
	this.filterOnTrucksName = "none";


	//this.isLockedAtStandby = false;
        this.isEmpty = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AutoChanger trucks POSITION = ");
        sb.append("\n Filter on trucks = ");
        sb.append(this.filterOnTrucksName);
        return sb.toString();
    }

    public void update(BasicAutoChangerModule autochanger) {
        filterOnTrucksName = autochanger.getFilterOnTrucksName();
        isEmpty = autochanger.isEmpty();
    }


    public boolean isEmpty() {
        return isEmpty;
    }

}
