/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.Sensor;

/**
 * This is a model for a latch. 
 * A latch is what holds a filter in the trucks of the autochanger.
 * There is 2 latches : one on each side of the filter.
 * The state of the  latches are monitoring by digital sensors :
 * one sensor to know if a filter is in the latch or not and 
 * 2 status sensors to know if the latch is locked or unlocked.
 * If the 2 status sensors are inconsistent, the latch is in error.
 * @author virieux
 */
public class FilterLatchModule extends Module implements Latch {

    private static class LatchError extends Exception {
        FilterLatchModule latch;
               
        public LatchError(String string, FilterLatchModule aThis) {
            super(string);
            latch = aThis;
        }
    }


    
    
    Actuator actuator;
    Sensor presenceFilterSensor;
    Sensor lockSensor;
    Sensor unlockSensor;

    
    public boolean isInError() {
        if (this.isLocked() && this.isUnlocked()) return true;
        else return false;
    }

    public String unlock()  throws BadCommandException, ErrorInCommandExecutionException {
        //TODO : check conditions
        if (!this.isLocked()) throw new BadCommandException("");
        actuator.on();
        try {
            updateStateWithSensors();
            while (this.isLocked()) {
                    Thread.sleep(this.tickMillis);
                    updateStateWithSensors();
            }
        } catch (InterruptedException ex) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        } catch (LatchError err) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, err);
        }
               
        if (this.isLocked() || this.isInError()) throw new ErrorInCommandExecutionException("");
        return getName() + "Unlocked";      
    }

    public String lock() throws BadCommandException, ErrorInCommandExecutionException {
        //TODO : check conditions
        if (!this.isUnlocked()) throw new BadCommandException("");
        actuator.off();
        try {
            updateStateWithSensors();
            while (this.isUnlocked()) {
                Thread.sleep(this.tickMillis);
                updateStateWithSensors();
            }
        } catch (InterruptedException ex) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        } catch (LatchError err) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, err);
        }
               
        if (this.isUnlocked() || this.isInError()) throw new ErrorInCommandExecutionException("");
        return getName() + ": Locked";      
    }

    public boolean isLocked() {       
        if (lockSensor.getValue() == 1) return true;
        else return false;
    }

    public boolean isUnlocked() {
        if (unlockSensor.getValue() == 1) return true;
        else return false;
    }

    private void updateStateWithSensors() throws LatchError {
        this.presenceFilterSensor.updateValue();
        this.lockSensor.updateValue();
        this.unlockSensor.updateValue();
        
        if (this.isInError()) throw new LatchError(getName() + "lock status sensors disagree",this);
    }
    
}
