/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.common.Sensor;

/**
 * This classe represents a ClampX- : 
 * a clamp which holds a filter on the carousel on the side X-
 * It is a concrete class for the abstract class FilterClampModule.
 * It has a sensor to mesure if the clamp is locked or not.
 * The sensor returns a numeric value.
 * The clamp is locked if this value is between minValue and maxValue.
 * @author virieux
 */
public class FilterClampXminusModule extends FilterClampModule {

    private Sensor lockSensor;
    int maxValue;
    int minValue;

    /**
     * @forSpring
     * @return the lockSensor
     */
    public Sensor getLockSensor() {
        return lockSensor;
    }

    /**
     * @forSpring
     * @param lockSensor the lockSensor to set
     */
    public void setLockSensor(Sensor lockSensor) {
        this.lockSensor = lockSensor;
    }

    @Override
    public boolean isLocked() {
        return (minValue < (double) lockSensor.getValue()) && ((double) lockSensor.getValue() < maxValue);
    }


}
