/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;

public class SimuFilterClampModule
extends FilterClampModule {
    private double trucksPositionLimit;
    private boolean atStandby;
    private CarouselModule carousel;

    @Override
    public boolean isLocked() {
        return !this.carousel.getClampsActuator().isOn();
    }

    @Override
    public void initModule() {
        this.initPublishedData();
        this.state = FilterClampState.CLAMPEDONFILTER;
        this.filterPresenceSensor.setValue(1);
        this.trucksPositionLimit = 5.0;
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.setAtStandby(false);
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        if (this.isAtStandby() && v.getName().equals(AutoChangerModule.publishedByAutoChangerOutputName)) {
            StatusDataPublishedByBasicAutoChanger data = (StatusDataPublishedByBasicAutoChanger)v.getValue();
            if (data.isEmpty() || data.getTrucksPosition() < this.trucksPositionLimit) {
                this.filterPresenceSensor.setValue(1);
            } else {
                this.filterPresenceSensor.setValue(0);
            }
            this.publishedByClamp.update(this);
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.publishedByClampOutputName, (Object)this.publishedByClamp));
        }
    }

    public boolean isAtStandby() {
        return this.atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }
}

