/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.common.FilterClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;

class ClampedOnFilter
implements FilterClampState {
    ClampedOnFilter() {
    }

    public String toString() {
        return "CLAMPED ON FILTER";
    }

    @Override
    public String unlock(FilterClamp clamp) throws ErrorInCommandExecutionException {
        while (clamp.isLocked()) {
            try {
                Thread.sleep(clamp.getTickMillis());
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!clamp.isLocked()) {
            clamp.setState(FilterClampState.UNCLAMPEDONFILTER);
            return String.valueOf(clamp.getName()) + " is unlocked";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(clamp.getName()) + " couldn't be unlocked.");
    }

    @Override
    public String release(FilterClamp filterClamp) {
        throw new UnsupportedOperationException("Not supported : can't release a clamp in state " + this.toString());
    }

    @Override
    public String lock(FilterClamp filterClamp) {
        throw new UnsupportedOperationException("The clamp is already locked.");
    }
}

