/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;

public class StatusDataPublishedByBasicAutoChanger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double trucksPosition = 0.0;
    private String filterOnTrucksName = "none";
    private String filterOnlineName = "none";
    private boolean isLockedAtStandby = false;
    private boolean isEmpty = false;

    public String toString() {
        StringBuilder sb = new StringBuilder("AutoChanger trucks POSITION = ");
        sb.append(this.getTrucksPosition());
        sb.append("\n Filter on trucks = ");
        sb.append(this.filterOnTrucksName);
        sb.append("/ Filter on line = ");
        sb.append(this.filterOnlineName);
        sb.append(" / Standby Latch = ");
        if (this.isLockedAtStandby) {
            sb.append("LOCKED");
        } else {
            sb.append("UNLOCKED");
        }
        return sb.toString();
    }

    public void update(BasicAutoChangerModule autochanger) {
        this.trucksPosition = autochanger.getTrucksPosition();
        this.filterOnTrucksName = autochanger.getFilterOnTrucksName();
        this.filterOnlineName = autochanger.getFilterOnlineName();
        this.isLockedAtStandby = autochanger.getStandbyLatch().isLocked();
        this.isEmpty = autochanger.isEmpty();
    }

    public double getTrucksPosition() {
        return this.trucksPosition;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

