/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;
import org.lsst.ccs.subsystems.fcs.common.NumericSensor;

public abstract class FilterClampModule
extends Module
implements FilterClamp {
    protected FilterClampState state;
    protected NumericSensor filterPresenceSensor;
    public String publishedByClampOutputName = "publishedByClamp";
    public StatusDataPublishedByClamp publishedByClamp;

    @Override
    public FilterClampState getState() {
        return this.state;
    }

    @Override
    public void setState(FilterClampState state) {
        this.state = state;
    }

    @Override
    public String release() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": is going to be released."));
        return this.state.release(this);
    }

    @Override
    public String unlock() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": is going to be unlocked."));
        Module.log.info((Object)(String.valueOf(this.getName()) + ": is in state " + this.state.toString()));
        return this.state.unlock(this);
    }

    @Override
    public String lock() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": is going to be locked."));
        return this.state.lock(this);
    }

    @Override
    public abstract boolean isLocked();

    @Override
    public void updateStateWithSensors() {
        this.state = this.filterPresenceSensor.getValue() == 1 ? (this.isLocked() ? FilterClampState.CLAMPEDONFILTER : FilterClampState.UNCLAMPEDONFILTER) : (this.isLocked() ? FilterClampState.READYTOCLAMP : FilterClampState.UNCLAMPEDEMPTY);
    }

    @Override
    public NumericSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    @Override
    public void setFilterPresenceSensor(NumericSensor filterPresence) {
        this.filterPresenceSensor = filterPresence;
    }

    public synchronized void tick() {
        this.updateStateWithSensors();
        this.publishedByClamp.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.publishedByClampOutputName, (Object)this.publishedByClamp));
    }

    public void initModule() {
        this.initPublishedData();
    }

    public void initPublishedData() {
        this.publishedByClamp = new StatusDataPublishedByClamp();
    }

    @Override
    public StatusDataPublishedByClamp getStatusData() {
        this.publishedByClamp.update(this);
        return this.publishedByClamp;
    }
}

