/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.HardwareErrorDetectedException;
import org.lsst.ccs.subsystems.fcs.common.FilterClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;

public abstract class CarouselSocket {
    private FilterClamp clampXminus;
    private FilterClamp clampXplus;
    private double position;
    private double standbyPosition;
    private Filter filter;

    public CarouselSocket() {
    }

    public CarouselSocket(double position) {
        this.position = position;
        this.standbyPosition = position == 0.0 ? 0.0 : 360.0 - position;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
    }

    public double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    public boolean isEmpty() throws HardwareErrorDetectedException {
        if (this.clampXminus.getFilterPresenceSensor().getValue() == 1 && this.clampXplus.getFilterPresenceSensor().getValue() == 1) {
            return false;
        }
        if (this.clampXminus.getFilterPresenceSensor().getValue() == 0 && this.clampXplus.getFilterPresenceSensor().getValue() == 0) {
            return true;
        }
        throw new HardwareErrorDetectedException("Error in filter presence detection at standby position : the clamps don't agree.");
    }

    public FilterClamp getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(FilterClamp clampXminus) {
        this.clampXminus = clampXminus;
    }

    public FilterClamp getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(FilterClamp clampXplus) {
        this.clampXplus = clampXplus;
    }

    public String unlockClamps() throws BadCommandException, ErrorInCommandExecutionException {
        this.clampXminus.unlock();
        this.clampXplus.unlock();
        return "Clamps are unlocked at standby position";
    }

    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException {
        this.clampXminus.release();
        this.clampXplus.release();
        return "Simulated Clamps are released at standby position";
    }

    public boolean isClampedOnFilter() {
        return this.clampXminus.getState().equals(FilterClampState.CLAMPEDONFILTER) && this.clampXplus.getState().equals(FilterClampState.CLAMPEDONFILTER);
    }

    public boolean isUnclampedAndEmpty() {
        return this.clampXminus.getState().equals(FilterClampState.UNCLAMPEDEMPTY) && this.clampXplus.getState().equals(FilterClampState.UNCLAMPEDEMPTY);
    }

    public synchronized void removeFilter() {
        this.setFilter(null);
    }

    public synchronized void putFilterOnSocket(Filter filter) {
        this.setFilter(filter);
        filter.setFilterLocation(FilterLocation.ONCAROUSEL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("position on the carousel:");
        sb.append("/ filter on socket : ");
        if (this.getFilter() == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.getFilter().getName()).append("\n");
        }
        sb.append(this.clampXminus.getStatusData().toString()).append("\n");
        sb.append(this.clampXplus.getStatusData().toString()).append("\n");
        return sb.toString();
    }

    public abstract void releaseClampsContact();

    public abstract void engageClampsContact();
}

