/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsMainModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FlipRailModule;
import org.lsst.ccs.subsystems.fcs.HardwareErrorDetectedException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.Carousel;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.FlipRailState;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;

public class CarouselModule
extends Module
implements Carousel {
    private static final long serialVersionUID = -2376279469784152348L;
    private Motor carouselMotor;
    private Actuator clampsActuator;
    protected int nbSockets;
    private CarouselSocket[] sockets;
    private Latch lock;
    public static String publishedByCarouselOutputName = "publishedByCarousel";
    private StatusDataPublishedByCarousel publishedByCarousel;
    private volatile ModuleState state;
    private boolean stopped;

    public CarouselModule() {
        this.sockets = new CarouselSocket[this.nbSockets];
        this.state = ModuleState.HALTED;
        this.stopped = false;
    }

    public void initModule() {
        Module.log.info((Object)"[CarouselModule] Initializing the carousel module ");
        this.initPublishedData();
        this.setState(ModuleState.HALTED);
    }

    public void initPublishedData() {
        this.publishedByCarousel = new StatusDataPublishedByCarousel(this.nbSockets);
    }

    public StatusDataPublishedByCarousel getStatusData() {
        this.publishedByCarousel.update(this);
        return this.publishedByCarousel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n Numbers of sockets: ");
        sb.append(this.nbSockets);
        int i = 0;
        while (i < this.nbSockets) {
            sb.append("\n Socket number ");
            sb.append(i);
            sb.append(" / ");
            sb.append(this.sockets[i].toString());
            ++i;
        }
        sb.append("\nClamps actuator  ").append(this.clampsActuator.toString()).append("\n");
        return sb.toString();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.publishedByCarousel.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByCarouselOutputName, (Object)this.publishedByCarousel));
    }

    @Override
    public double getPosition() {
        return this.carouselMotor.getPosition();
    }

    @Override
    public synchronized CarouselSocket getSocketAtStandby() {
        if (this.isRotating()) {
            return null;
        }
        CarouselSocket[] carouselSocketArray = this.sockets;
        int n = this.sockets.length;
        int n2 = 0;
        while (n2 < n) {
            CarouselSocket socket = carouselSocketArray[n2];
            if (this.getPosition() == socket.getStandbyPosition()) {
                return socket;
            }
            ++n2;
        }
        return null;
    }

    public synchronized Filter getFilterAtStandby() {
        if (this.getSocketAtStandby() == null) {
            return null;
        }
        return this.getSocketAtStandby().getFilter();
    }

    public synchronized String getFilterInStandbyName() {
        if (this.getFilterAtStandby() == null) {
            return "none";
        }
        return this.getFilterAtStandby().getName();
    }

    public boolean isReadyToGrabbeAFilterAtStandby() throws HardwareErrorDetectedException {
        if (this.isRotating()) {
            return false;
        }
        if (this.getSocketAtStandby() == null) {
            return false;
        }
        return this.getSocketAtStandby().isEmpty();
    }

    public boolean isRotating() {
        return this.carouselMotor.getEngineState().equals(EngineState.RUNNING);
    }

    @Override
    public boolean isAbleToMove() {
        FlipRailModule fliprail = (FlipRailModule)this.getModule("fliprail");
        return !this.lock.isLocked() && fliprail.state.equals((Object)FlipRailState.OPEN);
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public String stop() {
        String message;
        if (this.isRotating()) {
            this.stopped = true;
            message = "Stopping carousel";
            this.carouselMotor.stop();
            this.setState(ModuleState.HALTED);
        } else {
            message = "Carousel is already stopped";
        }
        return message;
    }

    @Override
    public String lock() {
        return this.lock.lock();
    }

    @Override
    public String unlock() {
        CommandReply myReply = new CommandReply((Object)"unlocking carousel", CommandReply.CommandStatus.OK);
        this.sendToReply(myReply);
        return this.lock.unlock();
    }

    @Override
    public String rotate(double angle) throws IllegalArgumentException, BadCommandException {
        double absAngle;
        if (angle < -360.0 || angle > 360.0) {
            throw new IllegalArgumentException("Please enter an angle between -360 and +360");
        }
        RunningWay way = null;
        if (angle >= 0.0) {
            absAngle = angle;
            way = RunningWay.POSITIVE;
        } else {
            absAngle = -angle;
            way = RunningWay.NEGATIVE;
        }
        double requiredPosition = CarouselModule.addAngle(this.getPosition(), angle);
        return this.rotate(absAngle, way, requiredPosition);
    }

    private String rotate(double angle, RunningWay runningWay, double finalPosition) throws BadCommandException, IllegalArgumentException {
        if (angle < 0.0 || angle > 360.0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " command rotate accepts angle only between 0 and 360)");
        }
        if (finalPosition < 0.0 || finalPosition > 360.0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " command rotate accepts finalPosition only between 0 and 360)");
        }
        String message = null;
        if (this.isRotating()) {
            message = "Carousel is rotating, stop it before sending a new rotate command.";
            Module.log.error((Object)message);
            throw new BadCommandException(message);
        }
        if (!this.isAbleToMove()) {
            message = "Carousel is unable to move. Check lock or flip rail.";
            Module.log.error((Object)message);
            throw new BadCommandException(message);
        }
        this.stopped = false;
        this.setState(ModuleState.RUNNING);
        this.getCarouselMotor().setRequiredPosition(finalPosition);
        this.sendToReply(new CommandReply((Object)"Please wait during carousel rotation...", CommandReply.CommandStatus.OK));
        this.carouselMotor.move(angle, runningWay);
        message = "Rotating to required position: " + finalPosition;
        Module.log.info((Object)message);
        while (this.isRotating()) {
            try {
                Module.log.info((Object)"...carousel rotating, please wait.....");
                Module.log.info((Object)(String.valueOf(this.getName()) + " WAITING TO BE AT REQUIRED POSITION=" + finalPosition));
                Module.log.info((Object)this.state.toString());
                Thread.sleep(this.tickMillis);
            }
            catch (InterruptedException interruptedException) {
                return "Sleeping interrupted";
            }
        }
        if (!this.isRotating()) {
            Module.log.info((Object)("THREAD=" + Thread.currentThread().getName()));
            this.setState(ModuleState.HALTED);
            Module.log.info((Object)"carousel is now stopped.");
            Module.log.info((Object)("filter in standby position: " + this.getFilterInStandbyName()));
            if (this.getPosition() == finalPosition) {
                message = "Command completed";
                Module.log.info((Object)message);
            } else {
                message = "Command non completed: carousel is not stopped at the required position";
                Module.log.info((Object)message);
            }
        }
        if (this.stopped) {
            message = "Command rotate carousel interrupted by command stop";
            Module.log.info((Object)message);
        }
        if (!this.stopped && this.getPosition() != finalPosition) {
            message = "Command non completed: carousel is not stopped at the required position";
            Module.log.error((Object)message);
        }
        return message;
    }

    public void tick() {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": socket at standby state : " + this.getSocketAtStandby().toString()));
    }

    private void putFilterOnCarousel(Filter filter) throws ErrorInCommandExecutionException, BadCommandException, HardwareErrorDetectedException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": there is no socket at standby position to put a filter in.");
        }
        if (this.getSocketAtStandby().isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": no filter is detected in socket at standby position so the operation putFilterOnCarousel is not available.");
        }
        this.getSocketAtStandby().putFilterOnSocket(filter);
        this.publishedByCarousel.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByCarouselOutputName, (Object)this.publishedByCarousel));
    }

    public void removeFilterFromCarousel(Filter filter) throws BadCommandException, HardwareErrorDetectedException, ErrorInCommandExecutionException {
        if (!this.getSocketAtStandby().getFilter().equals(filter)) {
            throw new BadCommandException(String.valueOf(this.getName()) + " : can't remove a filter which is not at standby position");
        }
        this.getSocketAtStandby().removeFilter();
        this.publishedByCarousel.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByCarouselOutputName, (Object)this.publishedByCarousel));
    }

    public double getFilterPosition(Filter filter) {
        double filterPosition = 0.0;
        int ix = 0;
        while (ix < this.sockets.length) {
            if (this.sockets[ix].getFilter() == filter) {
                filterPosition = this.sockets[ix].getPosition();
            }
            ++ix;
        }
        return filterPosition;
    }

    public double getStandbyPositionForFilter(Filter filter) {
        double position = 0.0;
        CarouselSocket[] carouselSocketArray = this.sockets;
        int n = this.sockets.length;
        int n2 = 0;
        while (n2 < n) {
            CarouselSocket socket = carouselSocketArray[n2];
            if (socket.getFilter() == filter) {
                position = socket.getStandbyPosition();
            }
            ++n2;
        }
        return position;
    }

    public int getSocketNumber(Filter filter) {
        int socketNumber = 0;
        int ix = 0;
        while (ix < this.sockets.length) {
            if (this.sockets[ix].getFilter() == filter) {
                socketNumber = ix;
            }
            ++ix;
        }
        return socketNumber;
    }

    protected String moveFilterToStandby(Filter filter) throws InterruptedException, BadCommandException {
        RunningWay runningWay;
        double angle;
        if (!filter.isOnCarousel()) {
            throw new IllegalArgumentException("filter: " + filter.getName() + " is not on carousel.");
        }
        String message = " [CarouselModule]";
        double requiredPosition = this.getStandbyPositionForFilter(filter);
        if (this.state == ModuleState.RUNNING) {
            throw new BadCommandException("Carousel is running, stop it before sending a new command.");
        }
        if (this.getPosition() == requiredPosition) {
            Module.log.info((Object)(String.valueOf(filter.getName()) + " is at STANDBY position on carousel."));
            return String.valueOf(filter.getName()) + " is at STANDBY position on carousel.";
        }
        if (this.getLatch().isLocked()) {
            Module.log.info((Object)"Carousel is locked. Unlocking carousel");
            this.unlock();
        }
        if ((angle = CarouselModule.addAngle(this.getPosition(), this.getFilterPosition(filter))) < 180.0) {
            runningWay = RunningWay.NEGATIVE;
        } else {
            angle = 360.0 - angle;
            runningWay = RunningWay.POSITIVE;
        }
        this.releaseClampsContact();
        this.rotate(angle, runningWay, requiredPosition);
        this.engageClampsContact();
        message = String.valueOf(message) + this.lock();
        return message;
    }

    public void printSockets() {
        int ix = 0;
        while (ix < this.sockets.length) {
            Module.log.info((Object)("Socket number: " + ix + " socket position: " + this.sockets[ix].getPosition() + " contains filter: " + this.sockets[ix].getFilter().getName()));
            ++ix;
        }
    }

    public String grabbeFilterAtStandby(Object filterName) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        FcsMainModule fcsMainModule = (FcsMainModule)this.getModule("main");
        fcsMainModule.controlFilterName(filterName);
        Module.log.info((Object)("Filter to move : " + filterName));
        Module.log.info((Object)("Filter location : " + (Object)((Object)fcsMainModule.getFilterByName((String)filterName).getFilterLocation())));
        return String.valueOf(this.getName()) + this.grabbeFilterAtStandby(fcsMainModule.getFilterByName((String)filterName));
    }

    public String grabbeFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        if (this.isRotating()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't grabbe a filter while rotating");
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + ": grabbing " + filter.getName() + " at standby position."));
        this.putFilterOnCarousel(filter);
        this.sendToReply(new CommandReply((Object)(String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on carousel."), CommandReply.CommandStatus.OK));
        String ack = String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed at standby position";
        return ack;
    }

    public void ungrabbeFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        if (!this.isOnStandby(filter)) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": filter has to be at standby position to be ejected");
        }
        if (!this.isClampedOnFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't ungrabbe filter which is already unclamped.");
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + ": ungrabbing " + filter.getName() + " at standby position."));
        this.unlockClamps();
        Module.log.info((Object)this.toString());
        Module.log.info((Object)(String.valueOf(this.getName()) + ": socket at standby state : " + this.getSocketAtStandby().toString()));
        Module.log.info((Object)this.toString());
        this.removeFilterFromCarousel(filter);
        Module.log.info((Object)(String.valueOf(this.getName()) + ": filter is removed from carousel at standby / " + this.getSocketAtStandby().toString()));
        this.sendToReply(new CommandReply((Object)(String.valueOf(this.getName()) + ": " + filter.getName() + " is ungrabbed from carousel."), CommandReply.CommandStatus.OK));
    }

    @Override
    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": releasing clamps on socket at standby position."));
        this.getClampsActuator().off();
        return this.getSocketAtStandby().releaseClamps();
    }

    @Override
    public String unlockClamps() throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": unlocking clamps on socket at standby position."));
        this.getClampsActuator().on();
        return this.getSocketAtStandby().unlockClamps();
    }

    private boolean isClampedOnFilterAtStandby() {
        return this.getSocketAtStandby().isClampedOnFilter();
    }

    public synchronized boolean isOnStandby(Filter filter) {
        return this.getPosition() == this.getStandbyPositionForFilter(filter);
    }

    public static double addAngle(double angle1, double angle2) {
        double angle = angle1 + angle2;
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public CarouselSocket[] getSockets() {
        return this.sockets;
    }

    public void setSockets(CarouselSocket[] sockets) {
        this.sockets = sockets;
    }

    public Motor getCarouselMotor() {
        return this.carouselMotor;
    }

    public void setCarouselMotor(Motor engine) {
        this.carouselMotor = engine;
    }

    public Latch getLatch() {
        return this.lock;
    }

    public void setLatch(Latch latch) {
        this.lock = latch;
    }

    public synchronized ModuleState getState() {
        return this.state;
    }

    public synchronized void setState(ModuleState state) {
        this.state = state;
    }

    public int getNbSockets() {
        return this.nbSockets;
    }

    public void setNbSockets(int nbSockets) {
        this.nbSockets = nbSockets;
    }

    private void releaseClampsContact() {
        this.getSocketAtStandby().releaseClampsContact();
    }

    private void engageClampsContact() {
        this.getSocketAtStandby().engageClampsContact();
    }

    public Actuator getClampsActuator() {
        return this.clampsActuator;
    }

    public void setClampsActuator(Actuator clampsActuator) {
        this.clampsActuator = clampsActuator;
    }
}

