/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.AutoChanger;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;

public abstract class BasicAutoChangerModule
extends Module
implements AutoChanger {
    private double trucksPositionOnline;
    private double trucksPositionAtStandby;
    private double trucksPositionSwapout;
    private boolean isEmpty;
    Filter filterOnTrucks;
    Motor motor;
    private Latch standbyLatch;
    private FilterClampModule latchXminus;
    private FilterClampModule latchXplus;
    public static String publishedByAutoChangerOutputName = "publishedByAutoChanger";
    private StatusDataPublishedByBasicAutoChanger publishedByBasicAutoChanger;
    private volatile ModuleState state = ModuleState.HALTED;

    @Override
    public Filter getFilterOnTrucks() {
        return this.filterOnTrucks;
    }

    public String getFilterOnTrucksName() {
        if (this.filterOnTrucks == null) {
            return "none";
        }
        return this.filterOnTrucks.getName();
    }

    @Override
    public Filter getFilterOnline() {
        if (this.getTrucksPosition() == this.getTrucksPositionOnline() && !this.isMoving()) {
            return this.filterOnTrucks;
        }
        return null;
    }

    public String getFilterOnlineName() {
        if (this.getFilterOnline() == null) {
            return "none";
        }
        return this.getFilterOnline().getName();
    }

    public Motor getMotor() {
        return this.motor;
    }

    public Latch getStandbyLatch() {
        return this.standbyLatch;
    }

    public StatusDataPublishedByBasicAutoChanger getStatusData() {
        this.publishedByBasicAutoChanger.update(this);
        return this.publishedByBasicAutoChanger;
    }

    @Override
    public double getTrucksPosition() {
        return this.motor.getPosition();
    }

    public double getTrucksPositionAtStandby() {
        return this.trucksPositionAtStandby;
    }

    public double getTrucksPositionOnline() {
        return this.trucksPositionOnline;
    }

    public double getTrucksPositionSwapout() {
        return this.trucksPositionSwapout;
    }

    private boolean isAbleToMove() {
        return true;
    }

    @Override
    public String goToPosition(double requiredPosition) throws IllegalArgumentException, BadCommandException {
        String message = null;
        if (requiredPosition > this.getTrucksPositionOnline() || requiredPosition < this.getTrucksPositionAtStandby()) {
            throw new IllegalArgumentException("Please enter a position between " + this.getTrucksPositionAtStandby() + " and " + this.getTrucksPositionOnline());
        }
        if (this.isMoving()) {
            message = "Auto-changer is moving, stop it before sending a new motion command.";
            Module.log.error((Object)message);
            throw new BadCommandException(message);
        }
        if (!this.isAbleToMove()) {
            message = "Auto-changer is unable to move because fliprail is open or online clamp is locked.";
            Module.log.error((Object)message);
            throw new BadCommandException(message);
        }
        this.setState(ModuleState.RUNNING);
        this.motor.setRequiredPosition(requiredPosition);
        Module.log.info((Object)(String.valueOf(this.getName()) + " is moving to position: " + requiredPosition));
        this.sendToReply(new CommandReply((Object)"Please wait during auto-changer motion...", CommandReply.CommandStatus.OK));
        message = "Moving to required position: " + requiredPosition;
        double displacement = requiredPosition - this.getTrucksPosition();
        this.motor.move(displacement);
        Module.log.info((Object)("AutoChanger moving to required position: " + requiredPosition + ", please wait..."));
        while (this.isMoving()) {
            try {
                Module.log.info((Object)"...auto-changer moving, please wait.....");
                Module.log.info((Object)(String.valueOf(this.getName()) + " WAITING TO BE AT REQUIRED POSITION=" + requiredPosition));
                Module.log.info((Object)this.state.toString());
                Thread.sleep(this.tickMillis);
            }
            catch (InterruptedException interruptedException) {
                return "Sleeping interrupted";
            }
        }
        if (!this.isMoving()) {
            Module.log.info((Object)("THREAD=" + Thread.currentThread().getName()));
            this.setState(ModuleState.HALTED);
            Module.log.info((Object)"auto-changer is now halted.");
            Module.log.info((Object)("filter on truck: " + this.getFilterOnTrucksName()));
            if (this.getTrucksPosition() == requiredPosition) {
                message = "goToPosition command completed";
                Module.log.info((Object)message);
            } else {
                message = "goToPosition command non completed: auto-changer is not stopped at the required position";
                Module.log.info((Object)message);
            }
        }
        Module.log.error((Object)message);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String grabbeFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException {
        if (this.filterOnTrucks != null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't grabbe a filter " + "when a filter is already loaded in trucks ");
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + ": grabbing " + filter.getName() + " at standby position."));
        this.closeFliprail();
        this.unlockLatchStandby();
        this.goToPosition(this.getTrucksPositionAtStandby());
        this.lockLatchStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = filter;
            this.setEmpty(false);
            filter.setFilterLocation(FilterLocation.ONAUTOCHANGER);
            this.updatePublishedDataAndNotifyObservers();
        }
        this.sendToReply(new CommandReply((Object)(String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on autochanger"), CommandReply.CommandStatus.OK));
        String ack = String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on autochanger";
        Module.log.info((Object)ack);
        return ack;
    }

    public void initModule() {
        Module.log.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ");
        this.setState(ModuleState.HALTED);
        this.initPublishedData();
        this.motor.setMinimalPosition(this.getTrucksPositionAtStandby());
        this.motor.setMaximalPosition(this.getTrucksPositionOnline());
    }

    @Override
    public void initPublishedData() {
        this.publishedByBasicAutoChanger = new StatusDataPublishedByBasicAutoChanger();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isMoving() {
        return this.motor.getEngineState().equals(EngineState.RUNNING);
    }

    @Override
    public synchronized void locateTrucks() {
        this.filterOnTrucks = null;
        this.setEmpty(true);
    }

    @Override
    public String lockLatchStandby() throws ErrorInCommandExecutionException {
        this.standbyLatch.lock();
        if (!this.standbyLatch.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": standby latch couldn't be locked.");
        }
        String ack = String.valueOf(this.getName()) + ": standby latch is locked";
        Module.log.info((Object)ack);
        return ack;
    }

    @Override
    public String moveFilterToOnline() throws BadCommandException, ErrorInCommandExecutionException {
        if (this.isEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
        if (this.getTrucksPosition() == this.getTrucksPositionOnline()) {
            throw new BadCommandException("Filter " + this.filterOnTrucks.getName() + " is already at online position.");
        }
        this.closeFliprail();
        this.goToPosition(this.getTrucksPositionOnline());
        if (this.getTrucksPosition() == this.getTrucksPositionOnline()) {
            Module.log.info((Object)(String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at online position"));
            this.closeOnlineClamp();
            return this.openFliprail();
        }
        Module.log.error((Object)"");
        return null;
    }

    @Override
    public String moveFilterToStandby() throws BadCommandException, ErrorInCommandExecutionException {
        if (this.isEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
        if (this.getTrucksPosition() == this.getTrucksPositionAtStandby()) {
            throw new BadCommandException("Filter " + this.filterOnTrucks.getName() + " is already at standby position.");
        }
        if (this.getTrucksPosition() != this.trucksPositionOnline) {
            throw new BadCommandException("Wrong position for autochanger trucks. Change to engineering mode.");
        }
        this.closeFliprail();
        this.openOnlineClamp();
        this.goToPosition(this.getTrucksPositionAtStandby());
        if (this.getTrucksPosition() == this.getTrucksPositionAtStandby()) {
            Module.log.info((Object)(String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at standby position."));
            return String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at standby position.";
        }
        String message = "the autochanger truck is not at the required position.";
        Module.log.error((Object)message);
        throw new ErrorInCommandExecutionException(message);
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.updatePublishedDataAndNotifyObservers();
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public void setFilterOnTrucks(Filter filterOnTrucks) {
        this.filterOnTrucks = filterOnTrucks;
    }

    public void setMotor(Motor motor) {
        this.motor = motor;
    }

    public void setStandbyLatch(Latch standbyLatch) {
        this.standbyLatch = standbyLatch;
    }

    private void setState(ModuleState s) {
        this.state = s;
    }

    public void setTrucksPositionAtStandby(double trucksPositionAtStandby) {
        this.trucksPositionAtStandby = trucksPositionAtStandby;
    }

    public void setTrucksPositionOnline(double trucksPositionOnline) {
        this.trucksPositionOnline = trucksPositionOnline;
    }

    public void setTrucksPositionSwapout(double trucksPositionSwapout) {
        this.trucksPositionSwapout = trucksPositionSwapout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n");
        sb.append("Trucks position = ");
        sb.append(this.getTrucksPosition()).append(" / ");
        sb.append("trucks position at standby = ");
        sb.append(this.getTrucksPositionAtStandby()).append(" / ");
        sb.append("trucks position online = ");
        sb.append(this.getTrucksPositionOnline()).append(" / ");
        sb.append("trucks position swapout = ");
        sb.append(this.getTrucksPositionSwapout()).append("\n");
        sb.append("Filter on trucks:");
        if (this.filterOnTrucks == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.filterOnTrucks.getName()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String stop() {
        String message;
        if (this.isMoving()) {
            message = "Stopping auto-changer";
            this.motor.stop();
            this.setState(ModuleState.HALTED);
        } else {
            message = "Auto-changer is already stopped";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unGrabbeFilterAtStandby() throws ErrorInCommandExecutionException, BadCommandException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": ungrabbing filter at standby position."));
        this.unlockLatchStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = null;
            this.setEmpty(true);
            this.updatePublishedDataAndNotifyObservers();
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + " trucks going empty to SWAPOUT position"));
        this.goToPosition(this.getTrucksPositionSwapout());
        this.openFliprail();
        String ack = String.valueOf(this.getName()) + ": trucks are empty at SWAPOUT position ";
        return ack;
    }

    @Override
    public String unlockLatchStandby() throws ErrorInCommandExecutionException {
        this.standbyLatch.unlock();
        if (this.standbyLatch.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": standby latch could not be unlocked.");
        }
        String ack = String.valueOf(this.getName()) + ": standby latch is unlocked";
        Module.log.info((Object)ack);
        return ack;
    }

    public abstract String openFliprail() throws ErrorInCommandExecutionException, BadCommandException;

    public abstract String closeFliprail() throws ErrorInCommandExecutionException;

    public abstract String openOnlineClamp() throws ErrorInCommandExecutionException;

    public abstract String closeOnlineClamp() throws ErrorInCommandExecutionException;

    public void updatePublishedDataAndNotifyObservers() {
        this.publishedByBasicAutoChanger.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByAutoChangerOutputName, (Object)this.publishedByBasicAutoChanger));
    }
}

