package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Latch;

/**
 * A simulated latch for the carousel.
 * This latch is unlock when a filter
 * is being moved from standby position to on line position
 * by the auto-changer or vice versa.
 * 
 * @author virieux
 *
 */
public class SimuLatch extends Module implements Latch {
	
	private boolean locked = false;

	public String lock() {
		locked = true;
                setChanged();
                notifyObservers(new ValueUpdate(getPublishDataOutputName(), this.locked));
                return getName() + "is locked";
	}

	public String unlock() {
		locked = false;
                setChanged();
                notifyObservers(new ValueUpdate(getPublishDataOutputName(), this.locked));
                return getName() + "is unlocked";
	}
	
	@Override
	public String toString() {
		if (locked)
			return "LOCKED";
		else
			return "UNLOCKED";
	}

	public boolean isLocked() {
		return locked;
	}

	public void setLocked(boolean locked) {
		this.locked = locked;
	}

        public String getPublishDataOutputName() {
            return getName() + " state";

        }
	


}
