/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;

/**
 * A simulated filter clamp module.
 * It has no sensor to know if the clamp is locked or not.
 * @author virieux
 */
public class SimuFilterClampModule extends FilterClampModule {

    /*
     * AutoChanger trucks position limit to know if a filter is
     * on carousel or not.
     */
    private double trucksPositionLimit;

    private boolean atStandby;

    private CarouselModule carousel;

    @Override
    public boolean isLocked() {
        return !carousel.getClampsActuator().isOn();
    }


    @Override
    public void initModule() {
        initPublishedData();
        state = FilterClampState.CLAMPEDONFILTER;
        filterPresenceSensor.setValue(1);
        trucksPositionLimit = 5;
        carousel = (CarouselModule) this.getModule("carousel");
        setAtStandby(false);
    }

    /**
    * What to do when the Modules we observe send there new values.
    * A Simulated clamp Module observes the autochanger.
     * When the trucks are under a limit, the simulated presence sensor is set to 1,
     * otherwise it's set to 0.
    *
    *
    */
    @Override
    public void processUpdate(Observable source, ValueUpdate v) {

          //The state of the simulated clamp changes with the autochanger trucks position.
          //But it changes only if the clamp is at standby position.

          if (this.isAtStandby() && v.getName().equals(AutoChangerModule.publishedByAutoChangerOutputName))  {
               StatusDataPublishedByBasicAutoChanger data = (StatusDataPublishedByBasicAutoChanger) v.getValue();
               //if autochanger trucks is empty : we suppose that the filter is on the carousel
               //so filter presence sensor returns 1
               //if autochanger trucks are loaded and position is > trucksPositionLimit
               //filter presence sensor returns 0
               if ( data.isEmpty()  ||  (data.getTrucksPosition() < trucksPositionLimit)) {
                   filterPresenceSensor.setValue(1);
               } else {
                   filterPresenceSensor.setValue(0);
               }

          this.publishedByClamp.update(this);
          setChanged();
          notifyObservers(new ValueUpdate(publishedByClampOutputName, this.publishedByClamp));
          }



    }

    /**
     * @return the atStandby
     */
    public boolean isAtStandby() {
        return atStandby;
    }

    /**
     * @param atStandby the atStandby to set
     */
    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }
}
