/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.FilterClampXminusModule;
import org.lsst.ccs.subsystems.fcs.FilterClampXplusModule;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;

/**
 *
 * @author virieux
 */
class ReadyToClampState implements FilterClampState {

    public String toString() {
        return "READY TO CLAMP";
    }

    //TODO if we have to do the same thing to unlock a clamp
    //when a filter is there or not, we'll have to refactor the code
    //with only 2 clamp states : CLAMPED or UNCLAMPED
    @Override
    public String unlock(FilterClamp clamp) {
        //TODO : there must be a timeout
        while (clamp.isLocked()) {

            try {
                Thread.sleep(clamp.getTickMillis());
            } catch (InterruptedException ex) {
                Logger.getLogger(ReadyToClampState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
 
        if (!clamp.isLocked()) {
            clamp.setState((FilterClampState) UNCLAMPEDEMPTY);
            return clamp.getName() + " is unlocked";
        }
        //TODO try to find something better to send !
        return null;
    }


    @Override
    public String release(FilterClamp clamp) {
        throw new UnsupportedOperationException(clamp.getName() + "Not supported: can't release a clamp in state " + toString());
    }

    @Override
    public String lock(FilterClamp clamp) {
        throw new UnsupportedOperationException(clamp.getName() +
                "The clamp is already locked : " + toString());
    }



}
