/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.FilterClampXminusModule;
import org.lsst.ccs.subsystems.fcs.FilterClampXplusModule;

/**
 * Carousel Filter Clamp State. Implements pattern state.
 * If the operations of : lock, unlock and release are the same
 * wether there's a filter in the socket or not, we'll change this
 * to have only 2 states.
 * @author virieux
 */
public interface FilterClampState {

    static public final ReadyToClampState READYTOCLAMP = new ReadyToClampState();
    static public final ClampedOnFilter CLAMPEDONFILTER = new ClampedOnFilter();
    static public final UnclampedOnFilter UNCLAMPEDONFILTER = new UnclampedOnFilter();
    static public final UnclampedEmpty UNCLAMPEDEMPTY = new UnclampedEmpty();

    /**
     * A method to unlock a carousel clamp which is locked. 
     * @param filterClamp
     * @return a String : a message for the operator at the console.
     * @throws BadCommandException 
     * @throws ErrorInCommandExecutionException 
     */
    String unlock(FilterClamp filterClamp)throws BadCommandException, ErrorInCommandExecutionException;

    String release(FilterClamp filterClamp) throws BadCommandException, ErrorInCommandExecutionException;

    String lock(FilterClamp filterClamp) throws BadCommandException, ErrorInCommandExecutionException;


}
