package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;


public interface FilterClamp {

        /**
        * @return the filterPresence
        */
        public NumericSensor getFilterPresenceSensor();

         /**
        * @param filterPresence the filterPresence to set
        */
        void setFilterPresenceSensor(NumericSensor filterPresence);


        public boolean isLocked();

        public void setState(FilterClampState state);
	public FilterClampState getState();
	
	public String release() throws BadCommandException, ErrorInCommandExecutionException;

        public String unlock() throws BadCommandException, ErrorInCommandExecutionException;

        public String lock() throws BadCommandException, ErrorInCommandExecutionException;

        public void updateStateWithSensors();

        public String getName();

        public int getTickMillis();

        public StatusDataPublishedByClamp getStatusData();

   
    



       
}
