package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;



/**
 * 
 * A structure for the data published on the status bus by the CarouselModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByCarousel implements Serializable {

	private static final long serialVersionUID = 7037058370873652888L;
	private double rotationInDegrees;
	private boolean isLocked;
	private String[] filterNames;
	private String filterInStandbyName;
        private String[] clampsInfo;
        private String actuatorState;

	StatusDataPublishedByCarousel(int nbSockets) {
		rotationInDegrees = 0.0;
		isLocked = false;
		filterNames = new String[nbSockets];
		for (int i = 0; i < filterNames.length; i++) {
			filterNames[i] = "";
		}
		filterInStandbyName = "none";
                clampsInfo = new String[nbSockets];
                actuatorState = null;
	}

        public void update(final CarouselModule carousel) {
                rotationInDegrees = carousel.getPosition();
                isLocked = carousel.isLocked();

		filterNames = new String[carousel.nbSockets];
		for (int i = 0; i < filterNames.length; i++) {
			if (carousel.getSockets()[i].getFilter() == null) {
				filterNames[i] = "empty";
			} else {
				filterNames[i] = carousel.getSockets()[i].getFilter().getName();
			}
		}

		filterInStandbyName = carousel.getFilterInStandbyName();

                for (int i = 0; i < carousel.nbSockets; i++) {
                    StringBuilder sb = new StringBuilder("Socket number: ");
                    sb.append(i).append("\n");
                    sb.append(carousel.getSockets()[i].toString());
                    clampsInfo[i] = sb.toString();
                }

                actuatorState = carousel.getClampsActuator().toString();
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder("Carousel POSITION = ");
		sb.append(this.rotationInDegrees);
		sb.append("; carousel is locked=");
		sb.append(this.isLocked);
		sb.append(";\n Filters on carousel:\n");
		for (int i = 0; i < filterNames.length; i++) {
			if (filterNames[i] == "empty") {
				sb.append("socket ");
				sb.append(i);
				sb.append(" is empty;");
			} else {
				sb.append(filterNames[i]);
				sb.append(" is on socket number ");
				sb.append(i);
				sb.append(";");				
			}
		}



		sb.append("\n Filter in Standby position= ");
		sb.append(this.filterInStandbyName).append("\n");

                for (int i = 0; i < clampsInfo.length; i++) {
                    sb.append(clampsInfo[i]);
                }

		return sb.toString();
	}

	public String getFilterInStandbyName() {
		return filterInStandbyName;
	}

	public String[] getFilterNames() {
		return filterNames;
	}

	public boolean isLocked() {
		return isLocked;
	}

	public double getRotationInDegrees() {
		return rotationInDegrees;
	}
}
