/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 * 
 * A structure for the data published on the status bus by a BasicAutoChangerModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByBasicAutoChanger implements Serializable {

    private static final long serialVersionUID = 1L;
	private double trucksPosition;
	private String filterOnTrucksName;
	private String filterOnlineName;
	private boolean isLockedAtStandby;
        private boolean isEmpty;

    public StatusDataPublishedByBasicAutoChanger() {
        super();
        this.trucksPosition = 0.0;
	this.filterOnTrucksName = "none";
	this.filterOnlineName = "none";

	this.isLockedAtStandby = false;
        this.isEmpty = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AutoChanger trucks POSITION = ");
        sb.append(this.getTrucksPosition());
        sb.append("\n Filter on trucks = ");
        sb.append(this.filterOnTrucksName);
        sb.append("/ Filter on line = ");
        sb.append(this.filterOnlineName);
        sb.append(" / Standby Latch = ");
        if (isLockedAtStandby) {
            sb.append("LOCKED");
        } else {
            sb.append("UNLOCKED");
        }
        return sb.toString();
    }

    public void update(BasicAutoChangerModule autochanger) {
        trucksPosition = autochanger.getTrucksPosition();
        filterOnTrucksName = autochanger.getFilterOnTrucksName();
        filterOnlineName = autochanger.getFilterOnlineName();
        isLockedAtStandby = autochanger.getStandbyLatch().isLocked();
        isEmpty = autochanger.isEmpty();
    }

    /**
     * @return the trucksPosition
     */
    public double getTrucksPosition() {
        return trucksPosition;
    }

    public boolean isEmpty() {
        return isEmpty;
    }

}
