package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.CommandReply.CommandStatus;
import org.lsst.ccs.subsystems.fcs.common.AutoChanger;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.common.FlipRailState;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.ModularSubsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Module.ValueUpdate;

public class AutoChangerModule extends BasicAutoChangerModule {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -3737919230282962231L;
	
	
	private FlipRailModule fliprail;
	
        private Latch onlineClamp;

        
        private StatusDataPublishedByAutoChanger publishedByAutoChanger;

        @Override
        public StatusDataPublishedByAutoChanger getStatusData() {
            this.publishedByAutoChanger.update(this);
            return this.publishedByAutoChanger;
        }

        @Override
        public void initPublishedData() {
            this.publishedByAutoChanger = new StatusDataPublishedByAutoChanger();
        }

	//TODO in real life check fliprail position
	private boolean isAbleToMove() {
		return (this.getFliprail().state.equals(FlipRailState.CLOSED))
				&& !this.onlineClamp.isLocked();
	}

	private Filter getFilterAtStandbyOnCarousel() {
                return ((FcsMainModule) this.getModule("main")).getFilterAtStandby();
	}

	/**
	 * when a filter is at online position it is locked by a clamp.
	 * when the clamp is closed, the filter is hold at online position.
	 * @throws ErrorInCommandExecutionException 
	 */
	public String closeOnlineClamp() throws ErrorInCommandExecutionException {
		this.onlineClamp.lock();
		if (!onlineClamp.isLocked())
			throw new ErrorInCommandExecutionException(getName() 
					+ "online clamp couldn't be closed.");
		String ack = getName() + ": online clamp closed";
		log.info(ack);
		return ack;
	}


	/**
	 * when a filter is at online position it is locked by a clamp.
	 * when the clamp is open, the filter is not hold at online position,
	 * so the autochanger can move the filter back to standby position.
	 * @throws ErrorInCommandExecutionException 
	 */
	public String openOnlineClamp() throws ErrorInCommandExecutionException {
		this.onlineClamp.unlock();
		if (onlineClamp.isLocked())
			throw new ErrorInCommandExecutionException(getName() 
					+ "online clamp couldn't be open.");
		String ack = getName() + ": online clamp open";
		log.info(ack);
		return ack;
	}
	
	public String openFliprail() throws ErrorInCommandExecutionException, BadCommandException {
		return getFliprail().open();
	}
	
	public String closeFliprail() throws ErrorInCommandExecutionException {
		return getFliprail().close();
	}






	public Latch getOnlineClamp() {
		return onlineClamp;
	}


	public void setOnlineClamp(Latch onlineClamp) {
		this.onlineClamp = onlineClamp;
	}


	public FlipRailModule getFliprail() {
		return this.fliprail;
	}


	public FlipRailState getFlipRailState() {
		return this.getFliprail().state;
	}

    /**
     * @param fliprail the fliprail to set
     */
    public void setFliprail(FlipRailModule fliprail) {
        this.fliprail = fliprail;
    }

    @Override
    public void updatePublishedDataAndNotifyObservers() {
            this.publishedByAutoChanger.update(this);
            setChanged();
            notifyObservers(new ValueUpdate(publishedByAutoChangerOutputName, this.publishedByAutoChanger));
    }





}
