/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.common.FilterClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;

class ReadyToClampState
implements FilterClampState {
    ReadyToClampState() {
    }

    public String toString() {
        return "READY TO CLAMP";
    }

    @Override
    public String unlock(FilterClamp clamp) {
        while (clamp.isLocked()) {
            try {
                Thread.sleep(clamp.getTickMillis());
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ReadyToClampState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!clamp.isLocked()) {
            clamp.setState(FilterClampState.UNCLAMPEDEMPTY);
            return String.valueOf(clamp.getName()) + " is unlocked";
        }
        return null;
    }

    @Override
    public String release(FilterClamp clamp) {
        throw new UnsupportedOperationException(String.valueOf(clamp.getName()) + "Not supported: can't release a clamp in state " + this.toString());
    }

    @Override
    public String lock(FilterClamp clamp) {
        throw new UnsupportedOperationException(String.valueOf(clamp.getName()) + "The clamp is already locked : " + this.toString());
    }
}

