/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsMainModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FlipRailModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FlipRailState;
import org.lsst.ccs.subsystems.fcs.common.Latch;

public class AutoChangerModule
extends BasicAutoChangerModule {
    private static final long serialVersionUID = -3737919230282962231L;
    private FlipRailModule fliprail;
    private Latch onlineClamp;
    private StatusDataPublishedByAutoChanger publishedByAutoChanger;

    @Override
    public StatusDataPublishedByAutoChanger getStatusData() {
        this.publishedByAutoChanger.update(this);
        return this.publishedByAutoChanger;
    }

    @Override
    public void initPublishedData() {
        this.publishedByAutoChanger = new StatusDataPublishedByAutoChanger();
    }

    private boolean isAbleToMove() {
        return this.getFliprail().state.equals((Object)FlipRailState.CLOSED) && !this.onlineClamp.isLocked();
    }

    private Filter getFilterAtStandbyOnCarousel() {
        return ((FcsMainModule)this.getModule("main")).getFilterAtStandby();
    }

    @Override
    public String closeOnlineClamp() throws ErrorInCommandExecutionException {
        this.onlineClamp.lock();
        if (!this.onlineClamp.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "online clamp couldn't be closed.");
        }
        String ack = String.valueOf(this.getName()) + ": online clamp closed";
        Module.log.info((Object)ack);
        return ack;
    }

    @Override
    public String openOnlineClamp() throws ErrorInCommandExecutionException {
        this.onlineClamp.unlock();
        if (this.onlineClamp.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "online clamp couldn't be open.");
        }
        String ack = String.valueOf(this.getName()) + ": online clamp open";
        Module.log.info((Object)ack);
        return ack;
    }

    @Override
    public String openFliprail() throws ErrorInCommandExecutionException, BadCommandException {
        return this.getFliprail().open();
    }

    @Override
    public String closeFliprail() throws ErrorInCommandExecutionException {
        return this.getFliprail().close();
    }

    public Latch getOnlineClamp() {
        return this.onlineClamp;
    }

    public void setOnlineClamp(Latch onlineClamp) {
        this.onlineClamp = onlineClamp;
    }

    public FlipRailModule getFliprail() {
        return this.fliprail;
    }

    public FlipRailState getFlipRailState() {
        return this.getFliprail().state;
    }

    public void setFliprail(FlipRailModule fliprail) {
        this.fliprail = fliprail;
    }

    @Override
    public void updatePublishedDataAndNotifyObservers() {
        this.publishedByAutoChanger.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, BasicAutoChangerModule.publishedByAutoChangerOutputName, (Object)this.publishedByAutoChanger));
    }
}

