/*
 * 
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import com.sun.jna.Library;
import com.sun.jna.Native;

/**
 * The purpose of this classe is just to test jna with a very basic example : Helloworld.
 * It's not used in the testbench application.
 * It uses the C printf fonction to print : "Hello, World". And it works fine.
 * This example comes from the <a href:"https://github.com/twall/jna#readme">web page for JNA on the github.com site</a>.
 * @author virieux
 */
public class HelloWorldWithJna {
 
    
    public interface CLibrary extends Library {
    
        CLibrary INSTANCE = (CLibrary) Native.loadLibrary("c", CLibrary.class);
      
        void printf(String format, Object... args);
    }


    // This is the standard, stable way of mapping, which supports extensive
    // customization and mapping of Java to native types.

    public static void main(String[] args) {
        CLibrary.INSTANCE.printf("Hello, World\n");
        for (int i=0;i < args.length;i++) {
            CLibrary.INSTANCE.printf("Argument %d: %s\n", i, args[i]);
        }
    }
}


