/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.CommandReply.CommandStatus;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.HardwareErrorDetectedException;

/**
 *
 * @author virieux
 */
public class SftMainModule extends Module {

    private Filter dummyFilter;

    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;

    @Override
    public void initModule() {

        carousel = (SftCarouselModule) this.getModule("carousel");
        
        
	autochanger = (SftAutoChangerModule) this.getModule("autochanger");
        this.locateFilters();
        autochanger.locateTrucks();
    }

    private void locateFilters() {
                carousel.getSockets()[0].putFilterOnSocket(dummyFilter);
                carousel.getSockets()[0].engageClampsContact();
    }

    public String printFilters() {

	StringBuilder sb = new StringBuilder(getName() + " printFilters \n ");

        sb.append(dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(dummyFilter));
	sb.append(" socket number: ").append(this.carousel.getSocketNumber(dummyFilter));
	sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(dummyFilter));


	log.info(sb.toString());
	return sb.toString();

    }

    public String toString() {
            StringBuilder sb = new StringBuilder(getName());
            sb.append("\n").append(carousel.toString());
            sb.append("\n").append(autochanger.toString());
            return sb.toString();
    }

    public String displayData() {
            StringBuilder sb = new StringBuilder("Data published by ");
            sb.append(getContext().getSubsystem().getName()).append("\n  ");
            sb.append(CarouselModule.publishedByCarouselOutputName);
            sb.append(carousel.getStatusData().toString());
            sb.append("\n  ");
            sb.append(AutoChangerModule.publishedByAutoChangerOutputName);
            sb.append(autochanger.getStatusData().toString());
            return sb.toString();
     }

    /**
     * Initial state for sequence1 :
     * autochanger is in highposition and trucks are empty
     * carousel hiold a filter and its clamps are in CLAMPEDONFILTER state.
     * @return
     */
    public String goToInitialStateForSequence1() {
        return null;
    }

    /**
     *
     * @return a message for the operator
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException
     */
    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {

        //autochanger trucks go to standby position to grabbe the filter held by carousel
	sendToReply(new CommandReply("Autochanger trucks moving empty to standby position.", CommandStatus.OK));
        autochanger.grabbeFilterAtStandby(getDummyFilter());

        // carousel clamps are opened and go in the READYTOCLAMP state
        // when autochanger moves up the filter
        sendToReply(new CommandReply("Carousel is ungrabbing filter at standby position.", CommandStatus.OK));
        carousel.ungrabbeFilterAtStandby(getDummyFilter());

        //autochanger trucks hold the filter are move it to Online Position
        sendToReply(new CommandReply("Autochanger trucks moving loaded with the filter to online position.", CommandStatus.OK));
        autochanger.moveFilterToOnline();

        carousel.releaseClamps();

        //then we go back to the initial position :
        //autochanger move back the filter in standby position
        sendToReply(new CommandReply("Autochanger trucks moving back the filter to standby position.", CommandStatus.OK));
        autochanger.moveFilterToStandby();

        // carousel checks if the filter is clamped at standby position
        sendToReply(new CommandReply("Carousel is grabbing filter at standby position.", CommandStatus.OK));
        carousel.grabbeFilterAtStandby(getDummyFilter());

        //then the autochanger can unclamp the filter and go to swapout position
        sendToReply(new CommandReply("Autochanger moving back empty to online position.", CommandStatus.OK));
        autochanger.unGrabbeFilterAtStandby();

        return getName() + " ready for another execution of sequence 1";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * @return the dummyFilter
     */
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    /**
     * @param dummyFilter the dummyFilter to set
     */
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    public Filter getFilterAtStandby() {
        return carousel.getFilterAtStandby();
    }
}
