/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.singlefiltertest;


import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;

/**
 * This class is for the Single Filter Test carousel.
 * The carousel in Single Filter Test has only one socket and
 * doesn't rotate.
 *
 * @author virieux
 */
public class SftCarouselModule extends CarouselModule {

    
    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSockets()[0];
    }

    @Override
    public double getPosition() {
        return 0;
    }

    @Override
    public boolean isAbleToMove() {
        return true;
    }

    public boolean isRotating() {
        return false;
    }

    @Override
    public String rotate(double angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }

    @Override
    public String stop () {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }
    

    @Override
    public String lock() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    @Override
    public String unlock(){
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

}
