/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;

/**
 *
 * @author virieux
 */
class UnclampedOnFilter implements FilterClampState {

    @Override
    public String toString() {
        return "UNCLAMPED ON FILTER";
    }

    @Override
    public String unlock(FilterClamp filterClamp) throws BadCommandException {
        throw new BadCommandException("The clamp is already unlocked");
    }


    @Override
    public String release(FilterClamp clamp) throws ErrorInCommandExecutionException {
        throw new UnsupportedOperationException(clamp.getName() + "Not supported: can't release a clamp in state " + toString());
    }

    /**
     *
     * Available in Engineering mode only.
     * @param clamp
     * @return
     * @throws ErrorInCommandExecutionException
     */
    @Override
    public String lock(FilterClamp clamp) throws ErrorInCommandExecutionException {

        if (!clamp.isLocked())
			throw new ErrorInCommandExecutionException(clamp.getName()
					+ ": clamp could not be unlocked.");

        return clamp.getName() + "is locked. ";
    }

}
