/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsAlerts;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSWithPDO;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOSLinearRailTruck
extends CanOpenEPOSWithPDO
implements EPOSControllerForLinearRail {
    static final Logger FCSLOG = Logger.getLogger(CanOpenEPOSLinearRailTruck.class.getName());
    @ConfigurationParameter(range="0..10000000", units="unitless", description="Minimal position of the encoder ribbon.", category="controller")
    private volatile int encoderRibbonMinValue;
    private boolean homingDone;
    private CanOpenEPOSLinearRailTruck otherAcTruckController;
    private boolean brakeActivatedPub = false;
    private boolean configDigitalInputOK = true;
    private boolean configDigitalOutputOK = true;
    private StringBuilder configDigitalInputSb;
    private StringBuilder configDigitalOutputSb;

    @Override
    public boolean isBrakeActivatedPub() {
        return this.brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
    }

    @Override
    public void init() {
        super.init();
        this.hasEncoder = true;
    }

    @Override
    public void build() {
        super.build();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.otherAcTruckController = this.getName().contains("Xminus") ? (CanOpenEPOSLinearRailTruck)lookup.getComponentByPath("acTruckXplusController") : (CanOpenEPOSLinearRailTruck)lookup.getComponentByPath("acTruckXminusController");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return true if homing is done: the controller knows its absolute position.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Do homing of the controller")
    public void homing() {
        int absolutePosition = this.readSSIPosition() - this.encoderRibbonMinValue;
        this.doHoming(absolutePosition);
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check whether homing of the truck needs to be done.")
    public void checkHomingNeeded() {
        this.checkInitialized();
        int ssiPosition = this.readSSIPosition();
        int absolutePosition = ssiPosition - this.encoderRibbonMinValue;
        int position = this.readPosition();
        String msg = this.getName() + " | encoderRibbonMinValue (configuration param)=" + this.encoderRibbonMinValue + ", SSI position=" + ssiPosition + ", Absolute position (ssi - ribbon value)=" + absolutePosition + ", Controller position=" + position;
        FCSLOG.finer(() -> msg);
        if (Math.abs(absolutePosition - position) < 10) {
            FCSLOG.info(this.getName() + " autochanger truck position is well calibrated with the SSIencoder.");
            this.homingDone = true;
        } else {
            FCSLOG.info(this.getName() + " homing should be done before moving.");
            this.homingDone = false;
            String error_msg = "Homing of the autochanger " + this.getName() + " truck is wrong or has been lost.\nThis is an abnormal situation, we should not have to redo the homing of the autochanger trucks.\nThe most probable cause is a wrong value of the encoderRibbonMinValue in the configuration. \nContact a FES expert with the following information\n" + msg;
            this.raiseAlarm(FcsAlerts.AC_TRUCKS_ERROR, error_msg);
        }
    }

    private void doHoming(int position) {
        FCSLOG.finer(() -> this.getName() + " ==> BEGIN homing");
        EPOSEnumerations.EposMode myMode = this.readMode();
        this.goToOperationEnable();
        this.defineAbsolutePosition(position);
        try {
            this.checkHomingDone(position);
            this.homingDone = true;
            FCSLOG.finer(() -> this.getName() + " ==> END homing");
        }
        catch (FcsHardwareException e) {
            this.homingDone = false;
            FCSLOG.warning(this.getName() + " ==> END homing with error: \n" + e.getMessage());
            throw e;
        }
        finally {
            this.changeMode(myMode);
            this.activateBrakeAndDisable();
        }
    }

    private void checkHomingDone(int position) {
        FcsUtils.waitCondition(() -> this.isTargetReached(), null, "checkTrucksHomingCompleted", 500L);
        if (!this.isTargetReached() || position != this.readPosition()) {
            throw new FcsHardwareException(this.getName() + " homing procedure could not be completed: target is not reached after 500 ms");
        }
        this.writeControlWord(EPOSEnumerations.ControlWord.SWITCH_ON);
    }

    @Override
    public void faultReset() {
        super.faultReset();
        this.otherAcTruckController.updateEposState();
        if (this.otherAcTruckController.getEposState() != EPOSEnumerations.EposState.FAULT) {
            this.otherAcTruckController.activateBrakeAndDisable();
            this.otherAcTruckController.publishData();
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalInputOfLinearRails() {
        this.writeParameter(EPOSEnumerations.EposParameter.ConfigurationOfDigitalInput1, 4);
        this.writeParameter(EPOSEnumerations.EposParameter.ConfigurationOfDigitalInput2, 5);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalInputFonctionnalityPolarity, 0);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalInputFonctionnalityMask, 48);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital input of linear rail controller.")
    public void checkConfigDigitalInputOfLinearRails() {
        this.configDigitalInputSb = new StringBuilder();
        this.configDigitalInputSb.append(" Configuration of Digital Input:");
        this.checkParamInput(EPOSEnumerations.EposParameter.ConfigurationOfDigitalInput1, 4);
        this.checkParamInput(EPOSEnumerations.EposParameter.ConfigurationOfDigitalInput2, 5);
        this.checkParamInput(EPOSEnumerations.EposParameter.DigitalInputFonctionnalityPolarity, 0);
        this.checkParamInput(EPOSEnumerations.EposParameter.DigitalInputFonctionnalityMask, 48);
        this.checkParamInput(EPOSEnumerations.EposParameter.DigitalInputFonctionnalityExecutionMask, 48);
        if (this.configDigitalInputOK) {
            FCSLOG.info(this.configDigitalInputSb.toString());
        } else {
            FCSLOG.severe(this.configDigitalInputSb.toString());
        }
    }

    private void checkParamInput(EPOSEnumerations.EposParameter param, int configValue) {
        int paramValue = (int)this.readParameter(param);
        if (configValue != paramValue) {
            this.configDigitalInputOK = false;
        }
        this.configDigitalInputSb.append(param).append("=");
        this.configDigitalInputSb.append(paramValue).append(";");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalOutputOfLinearRails() {
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityMask, 0);
        this.writeParameter(EPOSEnumerations.EposParameter.ConfigurationOfDigitalOutput1, 15);
        this.writeParameter(EPOSEnumerations.EposParameter.ConfigurationOfDigitalOutput2, 0);
        this.writeParameter(EPOSEnumerations.EposParameter.ConfigurationOfDigitalOutput3, 2);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityPolarity, 4);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityMask, 32773);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital output of linear rail controller.")
    public void checkConfigDigitalOutputOfLinearRails() {
        this.configDigitalOutputSb = new StringBuilder();
        this.configDigitalOutputSb.append(" Configuration of Digital Output:");
        this.checkParamOutput(EPOSEnumerations.EposParameter.ConfigurationOfDigitalOutput1, 15);
        this.checkParamOutput(EPOSEnumerations.EposParameter.ConfigurationOfDigitalOutput2, 0);
        this.checkParamOutput(EPOSEnumerations.EposParameter.ConfigurationOfDigitalOutput3, 2);
        this.checkParamOutput(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityPolarity, 4);
        this.checkParamOutput(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityMask, 32773);
        if (this.configDigitalOutputOK) {
            FCSLOG.info(this.configDigitalOutputSb.toString());
        } else {
            FCSLOG.severe(this.configDigitalOutputSb.toString());
        }
    }

    private void checkParamOutput(EPOSEnumerations.EposParameter param, int configValue) {
        int paramValue = (int)this.readParameter(param);
        if (configValue != paramValue) {
            this.configDigitalOutputOK = false;
        }
        this.configDigitalOutputSb.append(param).append("=");
        this.configDigitalOutputSb.append(paramValue).append(";");
    }

    public void shutdown() {
    }
}

