package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.FcsAlerts;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * Provides method checkSensors for all hardware controlled by sensors. If
 * sensors controlling the state of a hardware are in error, this hardware can't
 * be moved. The method checkSensors provided by this interface raises an Alert
 * of level ALARM and throws an Exception.
 *
 * The operator of the Filter Exchange System has to fix the issue in the
 * sensors to be able to move hardware again.
 *
 * @author virieux
 */
public interface ControlledBySensors extends AlertRaiser {

    /**
     * returns true if one or many sensors of this hardware is in error.
     *
     * @return
     */
    boolean isInError();

    /**
     * Reads sensors and compute state and check is if sensors are in error or not.
     * If sensors are in error, raises an Alert level ALARM and throws an Exception.
     *
     * @param fcsAlert
     * @param myName
     * @throws FcsHardwareException
     */
    default void checkSensors(FcsAlerts fcsAlert, String myName) {
        if (isInError()) {
            raiseAlarm(fcsAlert, myName + " sensors are in error.");
            throw new FcsHardwareException(myName + " sensors are in ERROR. Can't move.");
        }
    }
}
