/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal;

import java.time.Duration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.kafka.SALKafkaImplementation;
import org.lsst.sal.standalone.SALStandaloneImplementation;

public interface SAL<C extends SALCommand, E extends SALEvent, T extends SALTelemetry>
extends AutoCloseable {
    public static final Logger LOG = Logger.getLogger(SAL.class.getCanonicalName());

    public SALReceivedCommand<C> getNextCommand(Duration var1) throws SALException;

    public SALCommandResponse issueCommand(C var1) throws SALException;

    public void logEvent(E var1) throws SALException;

    public E getNextEvent(Duration var1) throws SALException;

    public void sendTelemetry(T var1) throws SALException;

    public T getTelemetry(Duration var1) throws SALException;

    @Override
    public void close() throws SALException;

    public String getSALVersion();

    public String getXMLVersion();

    public String getOSPLVersion();

    public static <C extends SALCommand, E extends SALEvent, T extends SALTelemetry> SAL<C, E, T> create(Class c, String resource) {
        return SAL.create(c, resource, new Properties());
    }

    public static <C extends SALCommand, E extends SALEvent, T extends SALTelemetry> SAL<C, E, T> create(Class c, String resource, Properties properties) {
        String salImplementation = System.getProperty("org.lsst.sal.implementation", "default").toLowerCase();
        if (salImplementation.equals("default")) {
            String useKafka = System.getenv("LSST_USE_KAFKA");
            salImplementation = useKafka != null ? "kafka" : "standalone";
        }
        LOG.log(Level.INFO, "Creating SAL Implementation {0}", salImplementation);
        switch (salImplementation) {
            case "standalone": {
                return new SALStandaloneImplementation();
            }
            case "kafka": {
                return new SALKafkaImplementation(c, resource, properties);
            }
        }
        throw new IllegalArgumentException("Unknown SAL implementation: " + salImplementation);
    }
}

