/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;

public class LoaderHook {
    @LookupName
    private String name;
    private final DigitalSensor closeSensor;
    private final DigitalSensor openSensor;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private boolean inError;

    public LoaderHook(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.closeSensor = closeSensor;
        this.openSensor = openSensor;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update state from sensors values.")
    public void updateState() {
        boolean bl = this.inError = this.closeSensor.isOn() && this.openSensor.isOn();
        this.lockStatus = this.closeSensor.isOn() && this.openSensor.isOn() ? FcsEnumerations.LockStatus.ERROR : (this.closeSensor.isOn() ? FcsEnumerations.LockStatus.CLOSED : (this.openSensor.isOn() ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display Loader hook information.")
    public synchronized String toString() {
        this.updateState();
        StringBuilder sb = new StringBuilder("+> " + this.name + " <+").append("\n");
        sb.append("+ LockStatus: ").append(this.lockStatus.name()).append("\n");
        sb.append("+ OpenSensor: ").append(this.openSensor.isOn() ? "ON" : "OFF").append("\n");
        sb.append("+ CloseSensor: ").append(this.closeSensor.isOn() ? "ON" : "OFF").append("\n");
        return sb.toString();
    }

    StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook() {
        return new StatusDataPublishedByLoaderHook(this.closeSensor.isOn(), this.openSensor.isOn(), this.inError, this.lockStatus);
    }
}

