import csv
import time 
from org.lsst.ccs.scripting import CCS
from java.lang import Long
import sys

CONTROLLERS = {
    0x2a: "acTruckXminusController",
    0x2c: "acTruckXplusController",
    0x30: "onlineClampXplusController",
    0x31: "onlineClampXminusController",
    0x32: "onlineClampYminusController",
    0xe: "latchXplusController",
    0xf: "latchXminusController",
    0xc: "carouselController",
    0x1a: "clampXminusController",
    0x1b: "clampXplusController",
}




def long_hex(value):
    return hex(value)[:-1]

class CarouselModeTest(object):
    def __init__(self, subsystem_name, node_id,time,timeA,timeR,nloop):
        self.node_id = node_id
        self.time = time/1000.
        self.timeA = timeA/1000.
        self.timeR = timeR/1000.
        self.nloop = nloop
        self.maxControlerError = 20
        self.totSsiError = 0
        self.maxSsiError = 15
        self.oneSsiError = []
        self.maxConError = 4
        self.oneConError= []
        self.codRel = 520
        self.codSSI = 516

        for i in range(self.maxSsiError) :
            self.oneSsiError.append(0)
        for i in range(self.maxConError) :
            self.oneConError.append(0)  

        controller_name = CONTROLLERS.get(node_id, None)
        if not controller_name:
            import sys
            sys.exit(1)

        print("Testing Mode switch for %s" % controller_name)
        CCS.attachSubsystem(subsystem_name, 3)
        self.ctl = CCS.attachSubsystem(subsystem_name + "/canbus0/" + controller_name)

    def write_sdo(self, index, subindex, size, value):
        self.ctl.sendSynchCommand("writeSDO",  index, subindex, size, value)        
        
    def read_sdo(self, index, subindex):
        return self.ctl.sendSynchCommand("readSDO", index, subindex)

    def fault_reset(self) :
        #self.ctl.sendSynchCommand("faultReset") 
        # disable voltage 
        self.ctl.sendSynchCommand("writeSDO",  0x6040, 0, 2, 0)
        time.sleep(.01)
        self.ctl.sendSynchCommand("writeSDO",  0x6040, 0, 2, 0x80)

    def doSSI(self,verbose=False) :
        # default initialisation of the outcome of the swap 
        # - should we do the swap ...once swap done it should be fault
        doSwap=True
        # - does teh controler is ok ... if we can get the controler working it will be False 
        controlerOk=True
        # - number of try for the swap 
        do_it=0 
        #print("swap %d = > %d " % (old,new) )
        while doSwap and (do_it < self.maxSsiError) and controlerOk :
            # counter of try 
            self.oneSsiError[do_it]+=1
            if do_it > 0 : self.totSsiError +=1
            do_it+=1
            # configure the carousel controler to the new way to measure position (520 relative ; 516 Aboslute ) 
            self.write_sdo(0x2210, 2, 2, self.codSSI)
            # take a breath 
            time.sleep(self.timeA)
            # it's when we move to absolute coding than there is issue ... 
            # I guess the controler has issue to compute the aboslute position = bug 
            # check if the swap has been successfull , THIS HAS TO BE DONE BEFORE CHECKING THE FAULT , OR YOU'll GET MORE FAULT ???? 
            ssiPosition = self.read_sdo(0x2211, 3)
            if ssiPosition <= 1 :
                # swap failled we should retry ...
                # we test this before clearing the fault on the controler if any to have the info,
                # this swap doesn't need error check as we move to 520 which doesn't trig error
                #remark I do it here with a direct write SDO ... don't call an other function : to fully controle what is done 
                if verbose : print("Swap %d failled due to ssiPosition = %s " % (do_it, ssiPosition ) )
                self.write_sdo(0x2210, 2, 2, self.codRel)
                time.sleep(self.timeR)
            else:
                doSwap=False
            #
            # check if the controler is in FAULT after the swap , this is rare but it happends 
            StatusWord=self.read_sdo(0x6041,0 )
            Fault= ( StatusWord & 8 ) > 0
            if Fault : 
                    # controler in Fault we should fix it first  
                    print("Controler in error (error nb= %d)  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  " % (self.oneConError[0]+1)) 
                    print("StatusWord = %s , FAULT = %s " % ( bin(StatusWord) ,Fault ))
                    # try to recover 
                    # first reset the controler , but give it some time to digest its error , before and after the reset : 
                    # those time are a key of the succes of the error clear  
                    # wait than the error is cleared ...it should work at the first try but I had to try twice 1 
                    waitingTime=0
                    ntry=0
                    steWait=.2
                    ErrNotClear=True
                    while ntry < self.maxConError  and ErrNotClear :
                        self.oneConError[ntry]+=1
                        time.sleep(steWait)
                        # clear the error
                        self.fault_reset()
                        # idem with a simple direct call : Doesn't work ! The resset needed ????
                        # self.ctl.sendSynchCommand("writeSDO",  0x6040, 0, 2, 0x80)
                        #
                        time.sleep(steWait)
                        ErrNotClear=( self.read_sdo(0x6041,0 ) & 8 ) > 0 
                        waitingTime+=2*steWait
                        ntry+=1
                    if ErrNotClear :
                        print("Impossible to Clear the error in the Controler in %f s will stop !!!!!" %(waitingTime) )
                        controlerOk = False
                    else : print("Controler Cleared in %f s with %d try ." %(waitingTime,ntry) )
                    # What ever happens we stop if we have too many Faults 
                    if self.oneConError[0] > self.maxControlerError :
                        print("More than %d Controler Error , we stop !!!!!"% (self.maxControlerError) )
                        controlerOk = False 
                    # if we succeded to clear the error we will re-do the swap , without testing it , to be sure , doSwap is already True here 
                    doSwap=True

        return (not(doSwap) and controlerOk)  
        

    def doRelat(self) :
        self.write_sdo(0x2210, 2, 2, self.codRel)
        # take a breath 
        time.sleep(self.timeR)
        return 

    def run(self,verbose=False):
        error=[]
        t0=time.time()
        print("=== Start ")
        ControlerStructure= self.read_sdo(0x2220 , 0)
        print("ControlerStructure = %s " % ( ControlerStructure ) )
        PositionSensorType= self.read_sdo(0x2210, 2)
        print("PositionSensorType = %s " % ( PositionSensorType ) )
        if PositionSensorType == 516  : 
            ssiPosition = self.read_sdo(0x2211, 3)
            if ssiPosition <= 1 :
                print("Force 516 as ssiPosition = %s " % ( ssiPosition ) )
                self.doRelat()
                result=self.doSSI()
                if result == False :
                    print("WTF ... we stop too many errors" )
                    sys.exit()
        # swap loop
        print("=== Loop on swap") 
        #old_error=0
        old_error_cont=0
        nbSwapSSI=0
        for iloop in range(self.nloop*2) :
            ControlerStructure = self.read_sdo(0x2220 , 0)
            PositionSensorType = self.read_sdo(0x2210, 2)
            if  ((iloop%int(self.nloop*2/10))==0)  or  old_error_cont != self.oneConError[0] :
                tend=time.time()-t0
                print("%5.1f dt=%f s cur=%d ; nb SSI error=%d ; tot controler clear=%d  " % (iloop/2,tend,PositionSensorType,self.totSsiError,self.oneConError[0]) )
                #old_error = self.oneSsiError[4]
                old_error_cont = self.oneConError[0] 
            if PositionSensorType == 516 :
                self.doRelat()
                result=True
            elif PositionSensorType == 520 :
                result=self.doSSI()
                nbSwapSSI+=1
            else :
                print("WTF ... we stop " )
                sys.exit(1)
            if result == False :
                print("WTF ... we stop too many errors" )
                break
            time.sleep(self.time)
        tend=time.time()-t0
        print("=== End after %f s (nb swap = %d , nb swap to Ssi = %d , nb error = %d , nb Controler Fault after swap = %d \n ,sleep time between swap =%f , After Absolute move =%f , Relative =%f s" % (tend,iloop,nbSwapSSI,self.totSsiError,self.oneConError[0],self.time,self.timeA,self.timeR) )
        for i in range(self.maxSsiError) :
            if self.oneSsiError[i] > 0 : 
                print ("number of event with %d error or more : % 4d " % (i,self.oneSsiError[i]))
        for i in range(self.maxConError) :
            if self.oneConError[i] > 0 : 
                print ("number of Controler Error Clear with %d try or more : % 4d " % (i+1,self.oneConError[i]))
        ControlerStructure= self.read_sdo(0x2220 , 0)
        print("ControlerStructure = %s " % ( ControlerStructure ) )
        PositionSensorType= self.read_sdo(0x2210, 2)
        print("PositionSensorType = %s " % ( PositionSensorType ) )
        if PositionSensorType == 516  : 
            ssiPosition = self.read_sdo(0x2211, 3)
            print("ssiPosition = %s " % ( ssiPosition ) )
            if ssiPosition <= 1 :
                print("WTF ... we stop " )
                sys.exit(1)
               
        
            
                
        


if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser("Carousel Change Mode test")
    parser.add_argument(
        "-n", "--nloop",
        type=int, default="1", help="Number of Mode swap to run ")
    parser.add_argument(
        "-a", "--timeA" ,  type=int, default="80",  help="Time to wait after WriteSDO coder 516 in ms ")
    parser.add_argument(
        "-r", "--timeR" ,  type=int, default="80",  help="Time to wait after WriteSDO coder 520 in ms ")
    parser.add_argument(
        "-t", "--time" ,  type=int, default="80",  help="Time to wait between swap mode in ms ")
    args = parser.parse_args()

    node_id = int('0xc', 16)
    print("Test of the Carousel Mode switch==== time between swap %d , after sawp to Absolute %d , Relative %d , nb loop %d  \n" % (args.time,args.timeA,args.timeR,args.nloop))
    if  node_id not in CONTROLLERS.keys():
        print("\n".join(["%s: %s" % (hex(k), v) for (k, v) in CONTROLLERS.items()]))
        import sys
        sys.exit(0)
    
    CarouselModeTest('fcs-PROTO',node_id,args.time,args.timeA,args.timeR,args.nloop).run()



