/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClampSensor;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.ActionTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CarouselClamp
extends MobileItem
implements MovedByEPOSController {
    private static final Logger FCSLOG = Logger.getLogger(CarouselClamp.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="canbus0")
    protected BridgeToHardware tcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private int id;
    protected EPOSController controller;
    private final SensorPluggedOnTTC580 filterPresenceSensor = new CarouselClampSensor();
    private final SensorPluggedOnTTC580 lockSensor = new CarouselClampSensor();
    private FcsEnumerations.FilterClampState clampState = FcsEnumerations.FilterClampState.UNDEFINED;
    private FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    @ConfigurationParameter(description="value of current to send to controller to unlock carousel clamp", range="-6000..6000", units="mA", category="carousel")
    protected volatile int currentToUnlock = -4660;
    @Persist
    protected volatile Integer lockSensorOffset1 = 5000;
    protected Integer filterPresenceMinLimit = 200;
    @Persist
    protected volatile Integer filterPresenceOffset2 = 3000;
    @ConfigurationParameter(description="An offset to account for a discrepancy in a given clamp filter presence sensor", range="0..1000", units="mV", category="carousel")
    protected volatile Integer filterPresenceOffset3 = 0;
    @ConfigurationParameter(description="Maximum value for the filter presence sensor on the clamp", range="0..12000", units="mV", category="carousel")
    private volatile Integer filterPresenceMaxValue = 12000;
    @ConfigurationParameter(description="Timeout for unlocking the clamp", range="0..10000", units="millisecond", category="carousel")
    protected volatile long timeoutForUnlocking = 1500L;
    @ConfigurationParameter(description="Timeout for releasing the clamp", range="0..10000", units="millisecond", category="carousel")
    protected volatile long timeoutForReleasing = 1500L;
    private int velocity = 0;
    private ArrayList<String> sensorErrorCounter;

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarouselClamp.class, this.path);
        this.movementCounter = new EnumMap(FcsEnumerations.MobileItemAction.class);
        for (FcsEnumerations.MobileItemAction action : new FcsEnumerations.MobileItemAction[]{FcsEnumerations.MobileItemAction.UNLOCK, FcsEnumerations.MobileItemAction.RELEASE}) {
            this.registerActionDuration(action);
            this.movementCounter.put(action, PersistentCounter.newCounter(action.getActionCounterPath(this.path), this.subs, action.name()));
        }
        String suffix = this.name.replace("clamp", "");
        ComponentLookup lookup = this.subs.getComponentLookup();
        ComponentNode thisNode = lookup.getComponentNodeForObject((Object)this);
        lookup.addComponentNodeToLookup(thisNode, new ComponentNode("filterPresence" + suffix, (Object)this.filterPresenceSensor));
        lookup.addComponentNodeToLookup(thisNode, new ComponentNode("lockSensor" + suffix, (Object)this.lockSensor));
    }

    public short getCurrentToUnlock() {
        return (short)this.currentToUnlock;
    }

    public ArrayList<String> getSensorErrorCounter() {
        return this.sensorErrorCounter;
    }

    protected void setController(EPOSController actuator) {
        this.controller = actuator;
    }

    public int getLockSensorOffset1() {
        return this.lockSensorOffset1;
    }

    public int getLockSensorMaxLimit() {
        if (this.isXminus()) {
            return this.carousel.getLockSensorMaxLimitXminus();
        }
        return this.carousel.getLockSensorMaxLimitXplus();
    }

    public int getLockSensorMinLimit() {
        if (this.isXminus()) {
            return this.carousel.getLockSensorMinLimitXminus();
        }
        return this.carousel.getLockSensorMinLimitXplus();
    }

    public int getFilterPresenceMinLimit() {
        return this.filterPresenceMinLimit;
    }

    public int getFilterPresenceOffset2() {
        return this.filterPresenceOffset2;
    }

    public SensorPluggedOnTTC580 getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public SensorPluggedOnTTC580 getLockSensor() {
        return this.lockSensor;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return the lockStatus")
    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public void setFilterPresenceOffset2(Integer value) {
        this.filterPresenceOffset2 = value;
    }

    public boolean isAvailable() {
        return this.carousel.getSocketByName("socket" + this.id).isAvailable();
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_SUCCESS.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_FAILURE.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_UNLOCKING_RECOVERY_SUCCESS.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_UNLOCKING_RECOVERY_FAILURE.getAlert(this.name), alwaysClear);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CANopen hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.controller.isInitialized();
    }

    public FcsEnumerations.FilterClampState getClampState() {
        return this.clampState;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp is locked")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    private boolean isAtStandby() {
        return this.carousel.getSocketAtStandbyID() == this.id;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp filter presence returns a value different from 0")
    public boolean isResponsive() {
        int fpresence = this.filterPresenceSensor.getValue();
        FCSLOG.info(this.name + " filterPresence value = " + fpresence);
        return fpresence > 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp state after a wake up is expected")
    public boolean isStabilised() {
        switch (this.clampState) {
            case READY_TO_CLAMP: 
            case CLAMPED_ON_FILTER: 
            case UNCLAMPED_EMPTY: {
                FCSLOG.info(this.name + " clamp state = " + this.clampState);
                return true;
            }
        }
        FCSLOG.info(this.name + " clamp not stabilised. Current clamp state = " + this.clampState);
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if filter is engaged on the clamp : filter presence sensors sees it ")
    public boolean isFilterEngaged() {
        return this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE;
    }

    public void checkAndUpdateOffset1(int newOffset1) {
        if (Math.abs(newOffset1 - this.lockSensorOffset1) > this.carousel.getMaxClampsOffsetDelta()) {
            this.lockSensorOffset1 = newOffset1;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " offset1 has changed; new value = " + newOffset1, this.name);
        }
    }

    public void checkAndUpdateOffset2(int newOffset2) {
        if (Math.abs(newOffset2 - this.filterPresenceOffset2) > this.carousel.getMaxClampsOffsetDelta()) {
            this.filterPresenceOffset2 = newOffset2;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " offset2 has changed; new value = " + newOffset2, this.name);
        }
    }

    public boolean isXminus() {
        return this.name.contains("Xminus");
    }

    public void updateFilterPresenceStatus() {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        if (newFilterPresenceSensorValue < this.filterPresenceMinLimit) {
            if (this.carousel.isRotating() || this.carousel.isAsleep()) {
                FCSLOG.info(this.name + String.format(this.name + " lost communication with TTC30 during rotation at position %d", this.carousel.getPosition()));
            } else if (this.isAvailable()) {
                this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
                String errorMsg = this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue + " must be >=" + this.filterPresenceMinLimit + " lost communication with TTC30 ?slip ring current = " + this.carousel.readSlipRingCurrent() + "mA";
                this.sensorErrorCounter.add(errorMsg);
                this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
            }
        } else if (newFilterPresenceSensorValue < this.filterPresenceOffset2 + this.filterPresenceOffset3) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.LOCKABLE;
        } else if (newFilterPresenceSensorValue < this.carousel.getFilterPresenceMinNoFilter()) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
        } else if (newFilterPresenceSensorValue < this.filterPresenceMaxValue) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOFILTER;
        } else if (this.isAvailable()) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            String errorMsg = this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue + " must be <=" + this.filterPresenceMaxValue;
            this.sensorErrorCounter.add(errorMsg);
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
        }
    }

    public void updateLockStatus() {
        int mechanicalValue = this.lockSensor.getValue();
        if (mechanicalValue < this.getLockSensorMinLimit()) {
            if (this.carousel.isRotating() || this.carousel.isAsleep()) {
                FCSLOG.info(this.name + String.format(this.name + " lost communication with TTC30 during rotation at position %d", this.carousel.getPosition()));
            } else if (this.isAvailable()) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
                String errorMsg = this.name + " ERROR new read value FOR LOCK SENSOR  = " + mechanicalValue + " should be >= " + this.getLockSensorMinLimit() + " lost communication with TTC30 ?\nslip ring current = " + this.carousel.readSlipRingCurrent() + "mA";
                this.sensorErrorCounter.add(errorMsg);
                this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
            }
        } else if (mechanicalValue < this.lockSensorOffset1) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechanicalValue <= this.lockSensorOffset1 + 500 && this.isXminus()) {
            this.lockStatus = FcsEnumerations.LockStatus.RELAXED;
        } else if (mechanicalValue <= this.carousel.getMinLockedThreshold()) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechanicalValue <= this.getLockSensorMaxLimit()) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else if (this.isAvailable()) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            String errorMsg = this.name + " ERROR new read value FOR LOCK SENSOR  = " + mechanicalValue + " should be <= " + this.getLockSensorMaxLimit();
            this.sensorErrorCounter.add(errorMsg);
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        CarouselClamp carouselClamp = this;
        synchronized (carouselClamp) {
            this.sensorErrorCounter = new ArrayList();
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.computeClampState();
            this.updateVelocity();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByCarouselClamp status = this.createStatusDataPublishedByClamp();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)status));
    }

    public StatusDataPublishedByCarouselClamp createStatusDataPublishedByClamp() {
        StatusDataPublishedByCarouselClamp status = new StatusDataPublishedByCarouselClamp();
        status.setClampState(this.clampState);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterPositionSensorValue(this.filterPresenceSensor.getValue());
        status.setLockSensorValue(this.lockSensor.getValue());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorOffset1(this.lockSensorOffset1.intValue());
        status.setFilterPresenceMinLimit(this.filterPresenceMinLimit.intValue());
        status.setFilterPresenceOffset2(this.filterPresenceOffset2.intValue());
        return status;
    }

    private void computeClampState() {
        if (this.lockStatus == FcsEnumerations.LockStatus.ERROR) {
            this.clampState = FcsEnumerations.FilterClampState.ERROR;
            return;
        }
        block0 : switch (this.filterPresenceStatus) {
            case ERROR: {
                this.clampState = FcsEnumerations.FilterClampState.ERROR;
                break;
            }
            case NOT_LOCKABLE: {
                this.clampState = FcsEnumerations.FilterClampState.UNLOCKABLE;
                break;
            }
            case LOCKABLE: {
                switch (this.lockStatus) {
                    case LOCKED: {
                        this.clampState = FcsEnumerations.FilterClampState.CLAMPED_ON_FILTER;
                        break block0;
                    }
                    case UNLOCKED: {
                        this.clampState = FcsEnumerations.FilterClampState.UNCLAMPED_ON_FILTER;
                        break block0;
                    }
                }
                this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
                break;
            }
            case NOFILTER: {
                switch (this.lockStatus) {
                    case LOCKED: {
                        this.clampState = FcsEnumerations.FilterClampState.READY_TO_CLAMP;
                        break block0;
                    }
                    case UNLOCKED: 
                    case RELAXED: {
                        this.clampState = FcsEnumerations.FilterClampState.UNCLAMPED_EMPTY;
                        break block0;
                    }
                }
                this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
                break;
            }
            default: {
                this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
            }
        }
        FCSLOG.fine(() -> this.name + " is " + this.filterPresenceStatus + " and " + this.lockStatus + " lockValue = " + this.lockSensor.getValue() + " clampState = " + this.clampState);
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Release clamp in order to get ready to clamp a filter again")
    public void release() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("CarouselClamp-release");){
            FCSLOG.info("Checking conditions for release clamp " + this.name + " on socket at standby position.");
            this.carousel.updateSocketAtStandbyReadSensorsNoPublication();
            FCSLOG.info("Releasing clamp " + this.name + " on socket at standby position.");
            this.executeAction(FcsEnumerations.MobileItemAction.RELEASE, this.timeoutForUnlocking);
        }
        this.carousel.updateSocketAtStandbyWithSensors();
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Check if controller has been disabled. For end user.")
    public boolean isReleased() {
        return !this.controller.isEnabled();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamp")
    public void unlock() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("CarouselClamp-unlock");){
            FCSLOG.info(this.name + ": UNLOCK State1 = " + this.clampState.toString());
            this.carousel.updateSocketAtStandbyReadSensorsNoPublication();
            if (this.isFilterEngaged() && this.autochanger.isAtStandby() && !this.autochanger.isHoldingFilter()) {
                throw new RejectedCommandException(this.name + "can ONLY unlock a clamp if FILTER is HELD by autochanger.");
            }
            try {
                this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK, this.timeoutForUnlocking);
            }
            catch (ActionTimeoutException ex) {
                this.recoveryUnlocking();
            }
        }
        this.carousel.updateSocketAtStandbyState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveryLocking() {
        int maxRetry = 3;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        int tryout = 0;
        boolean state_ok = false;
        while (tryout < 3 && !state_ok) {
            ++tryout;
            this.controller.goToOperationEnable();
            this.controller.writeCurrent((short)this.carousel.getRecoveryLockingCurrent());
            try {
                this.waitForLocked(800L, 250);
            }
            catch (RejectedCommandException ex) {
                FCSLOG.info(this.name + " recovery clamping tryout " + tryout + "/3 did not succeed" + String.format(" filter presence = %d lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()));
            }
            finally {
                this.controller.goToSwitchOnDisabled();
                if (!this.isLocked()) {
                    FcsUtils.sleep(200, this.name);
                    this.tcpProxy.updatePDOData();
                    this.carousel.updateSocketAtStandbyState();
                    duration = System.currentTimeMillis() - timeStart;
                    this.updateLockStatus();
                }
            }
            state_ok = this.isLocked();
        }
        if (!state_ok) {
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_FAILURE, String.format(this.name + " could not be LOCKED during allocated time, stop waiting. filter presence = %d, lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()), this.name);
            String msg = this.name + " LOCKING RECOVERY FAILED ";
            String cause = this.velocity > this.carousel.getRecoveryMaxVelocity() ? String.format("Cause = controller velocity reached %d which is over limit %d", this.velocity, this.carousel.getRecoveryMaxVelocity()) : String.format("Cause = couldn't go to state LOCKED during time allocated of %d ms;", duration);
            String msg_log = msg + cause + String.format("; filter presence value = %d lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue());
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_FAILURE, msg_log, this.name);
            FCSLOG.severe(msg_log);
            throw new FcsHardwareException(msg);
        }
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_SUCCESS, String.format(this.name + " clamp is finally LOCKED. filter presence = %d, lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()), this.name);
        FCSLOG.info(this.name + String.format(" go to state LOCKED duration = %d", duration));
    }

    private void waitForLocked(long timeoutMillis, int updateRate) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("CarouselClamp-waitForLocked");){
            FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> this.isLocked(), () -> {
                this.tcpProxy.updatePDOData();
                this.carousel.updateSocketAtStandbyState();
                this.updateLockStatus();
            }, "clampRecoveryLockingProcess", "carousel clamp recoveryLocking failed", timeoutMillis, updateRate);
        }
    }

    public void recoveryUnlocking() {
        long timeStart = System.currentTimeMillis();
        if (this.getClampState() == FcsEnumerations.FilterClampState.UNCLAMPED_ON_FILTER) {
            FCSLOG.info("The carousel " + this.name + " is already unlocked. Canceling recovery.");
            return;
        }
        int[] currentRamp = new int[]{0, -150, -500, -1200, -1900, -2600, -3400, -4950};
        this.tcpProxy.updatePDOData();
        this.updateState();
        for (int current : currentRamp) {
            this.controller.enableAndWriteCurrent(current);
            this.tcpProxy.updatePDOData();
            this.updateState();
            if (current == 0) {
                FcsUtils.sleep(2000, this.name);
                continue;
            }
            FcsUtils.sleep(500, this.name);
        }
        this.carousel.waitForStateUnclampedOnFilter(5000L);
        long duration = System.currentTimeMillis() - timeStart;
        String debug = String.format("\nfilter presence value = %d, lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue());
        if (!this.carousel.isUnclampedOnFilterAtStandby()) {
            this.carousel.getSocketAtStandby().recoveryReleaseClamps();
            String msg = String.format("Carousel socket %s could not be UNLOCKED after recoveryUnlocking during allocated time of %d ms.", this.name, duration);
            Object help = String.format("\nThis means filter %s cannot be extracted from the carousel %s currently.", this.carousel.getSocketAtStandby().getFilterObservatoryName(), this.carousel.getSocketAtStandby().getName());
            help = (String)help + "\nThis socket should probably be set unavailable until a FES expert can troubleshoot the issue with the unlocking.";
            help = (String)help + "\nFirst get the autochanger out of the way, use 'fcs/autochanger moveEmptyFromStandbyToHandoff' (level 1)";
            help = (String)help + "\nSecond go set the relevant socket as not available using 'fcs/carousel/socketX setUnavailable' (level 1)";
            FCSLOG.severe(msg + debug);
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_UNLOCKING_RECOVERY_FAILURE, msg + debug, this.name);
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_UNLOCKING_RECOVERY_FAILURE, msg + (String)help, this.name);
            throw new FcsHardwareException(msg);
        }
        String successMsg = String.format("%s recoveryUnlocking reached state UNLOCKED in %d ms", this.name, duration);
        FCSLOG.info(successMsg);
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_UNLOCKING_RECOVERY_SUCCESS, successMsg + debug, this.name);
    }

    public void recoveryUnlockingAndMoveFilterOnline() {
        if (!(this.autochanger instanceof Autochanger)) {
            throw new FcsHardwareException(this.name + " this recovery method should only be used on the real hardware, not the simulation.");
        }
        Autochanger ac = (Autochanger)this.autochanger;
        this.recoveryUnlocking();
        if (!this.carousel.isUnclampedOnFilterAtStandby()) {
            this.carousel.getSocketAtStandby().recoveryReleaseClamps();
            ac.moveEmptyFromStandbyToHandoff();
            String msg = "The carousel " + this.name + " unlocking recovery on " + this.carousel.getSocketAtStandby().getName() + " did not succeed. After recovery the clamp " + this.name + " ended in state " + this.getClampState().toString() + " Both carousel clamps were released to avoid damaging the system and the autochanger was moved empty to HANDOFF position. We recommend that the socket be set to 'unavailable' for the time being to avoid further damage.";
            throw new FcsHardwareException(this.name + msg);
        }
        FCSLOG.info("The carousel " + this.name + " is now unlocked, recovery successful. Proceeding with disengaging the filter and releasing the clamps before moving the filter ONLINE.");
        ac.moveToApproachStandbyPositionWithLowVelocity();
        this.carousel.releaseClamps();
        ac.moveAndClampFilterOnline();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case UNLOCK: {
                this.controller.goToOperationEnable();
                int timeToPrepareUnlock = this.carousel.getTimeToPrepareUnlock();
                short currentToPrepareUnlock = (short)this.carousel.getCurrentToPrepareUnlock();
                this.controller.writeCurrent(currentToPrepareUnlock);
                FcsUtils.sleep(timeToPrepareUnlock, this.name);
                this.controller.writeCurrent((short)this.currentToUnlock);
                break;
            }
            case RELEASE: {
                this.controller.goToSwitchOnDisabled();
                break;
            }
            default: {
                throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
            }
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case UNLOCK: {
                return this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED;
            }
            case RELEASE: {
                return !this.controller.isInState(EPOSEnumerations.EposState.OPERATION_ENABLE);
            }
        }
        throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.carousel.updateSocketAtStandbyReadSensorsNoPublication();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is ABORTING action " + action.toString() + " within delay " + delay);
        FCSLOG.finer(() -> this.name + " NOTHING BEING DONE HERE");
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.finer(() -> this.name + " is ENDING action " + action.toString());
        this.carousel.updateStateWithSensors();
        FCSLOG.finer(() -> this.name + " NOTHING BEING DONE HERE");
    }

    public void checkVelocity() {
        FCSLOG.info(this.name + " checking velocity; velocity = " + this.controller.getVelocity());
        FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> Math.abs(this.controller.getVelocity()) < 20, () -> this.tcpProxy.updatePDOData(), this.name + " check controller velocity is around 0 after unlock ", this.name + ": controller velocity is too high after trying every 100ms during 500 ms", 500L, 100L);
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet. Not relevant to stop action clamps.");
    }

    @Override
    public EPOSController getController() {
        return this.controller;
    }

    public void updateVelocity() {
        this.velocity = this.isAtStandby() ? this.controller.getVelocity() : 0;
    }

    public void postStart() {
        this.id = Integer.parseInt(this.name.substring(this.name.length() - 1));
        FCSLOG.info(this.name + " ID =" + this.id);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns a String representation of a CarouselClamp")
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("+> " + this.name + " <+").append("\n");
        sb.append("+ clamp state: ").append(this.clampState).append("\n");
        sb.append("+ lock status: ").append(this.lockStatus).append("\n");
        sb.append("+ lock sensor value: ").append(this.lockSensor.getValue()).append("\n");
        sb.append("+ filter presence status: ").append(this.filterPresenceStatus).append("\n");
        sb.append("+ filter presence value: ").append(this.filterPresenceSensor.getValue()).append("\n");
        sb.append("~~~").append("\n");
        return sb.toString();
    }
}

