###############################################################
#Script to test the real hardware of autochanger trucks.
#Tested on CPPM test bench in september 2015.
###############################################################

from org.lsst.ccs.scripting import CCS
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import *
from time import sleep
import java.time

 
timeoutFiveMillis = java.time.Duration.ofMillis(5)
timeoutTenSec = java.time.Duration.ofSeconds(10)


CCS.setThrowExceptions(True)

cppm = CCS.attachSubsystem("testbenchCPPM")
#cppm = CCS.attachSubsystem("autochanger-standalone")

print "Connected to testbenchCPPM => ", cppm
#print "Connected to autochanger-standalone=> ", cppm

ccsVersion= cppm.sendSynchCommand(timeoutFiveMillis,"getCCSVersions")
print "TESTS of autochanger trucks motion with CCS version number"
print ccsVersion.getResult()

#print "Date=", date

tcpProxy = CCS.attachSubsystem("testbenchCPPM/tcpProxy")
#tcpProxy = CCS.attachSubsystem("autochanger-standalone/tcpProxy")

result = tcpProxy.sendSynchCommand(timeoutFiveMillis, "isHardwareReady")

print "isHardwareReady =", result.getResult()

trucks = CCS.attachSubsystem("testbenchCPPM/trucks")
##################################INITIALIZATION

standbyPosition = int((trucks.sendSynchCommand(timeoutFiveMillis, "getStandbyPosition")))
print "STANDBY position=", standbyPosition

handoffPosition = int((trucks.sendSynchCommand(timeoutFiveMillis, "getHandoffPosition")))
print "HANDOFF position = ", handoffPosition

onlinePosition = int((trucks.sendSynchCommand(timeoutFiveMillis, "getOnlinePosition")))
print "ONLINE position =", onlinePosition

waitTime = int(1)

######################################################################
# check that initial conditions are OK
######################################################################

#Read of the linearRailSlaveController mode
slaveCtl = CCS.attachSubsystem("testbenchCPPM/linearRailSlaveController")
#slaveCtl = CCS.attachSubsystem("autochanger-standalone/linearRailSlaveController")
slaveMode = slaveCtl.sendSynchCommand(timeoutFiveMillis, "readMode")
print "Slave Controller Mode =", slaveMode.getResult()

#Read of the linearRailMasterController mode
masterCtl = CCS.attachSubsystem("testbenchCPPM/linearRailMasterController")
#masterCtl = CCS.attachSubsystem("autochanger-standalone/linearRailMasterController")
masterMode = masterCtl.sendSynchCommand(timeoutFiveMillis, "readMode")
print "Master Controller Mode =", masterMode.getResult()

if str(slaveMode.getResult()) != 'MASTER_ENCODER' :
   #  raise Exception("ERROR on slave Controller mode")
   print "ERROR on slave Controller mode - have to change it."
   result = slaveCtl.sendSynchCommand(timeoutFiveMillis,"changeMode MASTER_ENCODER")
else:
   print "slave Controller is in mode", slaveMode.getResult()

if str(masterMode.getResult()) != 'PROFILE_POSITION' :
   #  raise Exception("ERROR on master Controller mode")
   print "ERROR on master Controller mode - have to change it."
   result = masterCtl.sendSynchCommand(timeoutFiveMillis, "changeMode PROFILE_POSITION")
else:
   print "master Controller is in mode", masterMode.getResult()

######################################################################
# Move Trucks to STANDBY position if trucks are not already at STANDBY
######################################################################

position = int((masterCtl.sendSynchCommand(timeoutFiveMillis, "readPosition")))
print "INITIAL POSITION Position =", position
if position > standbyPosition +5 or position < standbyPosition - 5:
   print "Going to INITIAL position STANDBY"
   resultMvt=trucks.sendSynchCommand(timeoutTenSec,"goToStandby")
   print "resultMvt=", str(resultMvt)
   position = int((masterCtl.sendSynchCommand(timeoutFiveMillis, "readPosition")))
   print "Position=", position
   sleep(waitTime)
   print "END OF GOING TO INITIAL POSITION"

#####################################################################
# loop to move the trucks from STANDBY to HANDOFF
#####################################################################

for i in range(5):
   print "ITERATION number", i
   print "Going to HANDOFF"
   resultMvt = trucks.sendSynchCommand(timeoutTenSec, "goToHandoff")
  #print "resultMvt = ", str(resultMvt)
   position = int((masterCtl.sendSynchCommand(timeoutFiveMillis, "readPosition")))
   print "Position =", position
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "Going to STANDBY"
   resultMvt = trucks.sendSynchCommand(timeoutTenSec, "goToStandby")
  #print "resultMvt=", str(resultMvt)
   position = int((masterCtl.sendSynchCommand(timeoutFiveMillis, "readPosition")))
   print "Position =", position
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "end ITERATION number", i

print "END LOOP"


  





