/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public final class CanSocket
implements Closeable {
    public static final CanInterface CAN_ALL_INTERFACES;
    public static final int CAN_MTU;
    public static final int CAN_FD_MTU;
    private static final int CAN_RAW_FILTER;
    private static final int CAN_RAW_ERR_FILTER;
    private static final int CAN_RAW_LOOPBACK;
    private static final int CAN_RAW_RECV_OWN_MSGS;
    private static final int CAN_RAW_FD_FRAMES;
    private final int _fd;
    private final Mode _mode;
    private CanInterface _boundTo;

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        int BYTE_BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibFromJar(String libName) throws IOException {
        Objects.requireNonNull(libName);
        String fileName = "/lib/lib" + libName + ".so";
        FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
        Path tempSo = Files.createTempFile(CanSocket.class.getName(), ".so", permissions);
        try {
            try (InputStream libstream = CanSocket.class.getResourceAsStream(fileName);){
                if (libstream == null) {
                    throw new FileNotFoundException("jar:*!" + fileName);
                }
                try (OutputStream fout = Files.newOutputStream(tempSo, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                    CanSocket.copyStream(libstream, fout);
                }
            }
            System.load(tempSo.toString());
        }
        finally {
            Files.delete(tempSo);
        }
    }

    private static native int _getCANID_SFF(int var0);

    private static native int _getCANID_EFF(int var0);

    private static native int _getCANID_ERR(int var0);

    private static native boolean _isSetEFFSFF(int var0);

    private static native boolean _isSetRTR(int var0);

    private static native boolean _isSetERR(int var0);

    private static native int _setEFFSFF(int var0);

    private static native int _setRTR(int var0);

    private static native int _setERR(int var0);

    private static native int _clearEFFSFF(int var0);

    private static native int _clearRTR(int var0);

    private static native int _clearERR(int var0);

    private static native int _openSocketRAW() throws IOException;

    private static native int _openSocketBCM() throws IOException;

    private static native void _close(int var0) throws IOException;

    private static native int _fetchInterfaceMtu(int var0, String var1) throws IOException;

    private static native int _fetch_CAN_MTU();

    private static native int _fetch_CAN_FD_MTU();

    private static native int _discoverInterfaceIndex(int var0, String var1) throws IOException;

    private static native String _discoverInterfaceName(int var0, int var1) throws IOException;

    private static native void _bindToSocket(int var0, int var1) throws IOException;

    private static native CanFrame _recvFrame(int var0) throws IOException;

    private static native void _sendFrame(int var0, int var1, int var2, byte[] var3) throws IOException;

    private static native int _fetch_CAN_RAW_FILTER();

    private static native int _fetch_CAN_RAW_ERR_FILTER();

    private static native int _fetch_CAN_RAW_LOOPBACK();

    private static native int _fetch_CAN_RAW_RECV_OWN_MSGS();

    private static native int _fetch_CAN_RAW_FD_FRAMES();

    private static native void _setsockopt(int var0, int var1, int var2) throws IOException;

    private static native int _getsockopt(int var0, int var1) throws IOException;

    public CanSocket(Mode mode) throws IOException {
        switch (mode) {
            case BCM: {
                this._fd = CanSocket._openSocketBCM();
                break;
            }
            case RAW: {
                this._fd = CanSocket._openSocketRAW();
                break;
            }
            default: {
                throw new IllegalStateException("unkown mode " + mode);
            }
        }
        this._mode = mode;
    }

    public void bind(CanInterface canInterface) throws IOException {
        CanSocket._bindToSocket(this._fd, canInterface._ifIndex);
        this._boundTo = canInterface;
    }

    public void send(CanFrame frame) throws IOException {
        CanSocket._sendFrame(this._fd, frame.canIf._ifIndex, frame.canId._canId, frame.data);
    }

    public CanFrame recv() throws IOException {
        return CanSocket._recvFrame(this._fd);
    }

    @Override
    public void close() throws IOException {
        CanSocket._close(this._fd);
    }

    public int getMtu(String canif) throws IOException {
        return CanSocket._fetchInterfaceMtu(this._fd, canif);
    }

    public void setLoopbackMode(boolean on) throws IOException {
        CanSocket._setsockopt(this._fd, CAN_RAW_LOOPBACK, on ? 1 : 0);
    }

    public boolean getLoopbackMode() throws IOException {
        return CanSocket._getsockopt(this._fd, CAN_RAW_LOOPBACK) == 1;
    }

    public void setRecvOwnMsgsMode(boolean on) throws IOException {
        CanSocket._setsockopt(this._fd, CAN_RAW_RECV_OWN_MSGS, on ? 1 : 0);
    }

    public boolean getRecvOwnMsgsMode() throws IOException {
        return CanSocket._getsockopt(this._fd, CAN_RAW_RECV_OWN_MSGS) == 1;
    }

    static {
        String LIB_JNI_SOCKETCAN = "cansocket";
        try {
            System.loadLibrary("cansocket");
        }
        catch (UnsatisfiedLinkError e) {
            try {
                CanSocket.loadLibFromJar("cansocket");
            }
            catch (IOException _e) {
                throw new UnsatisfiedLinkError("cansocket");
            }
        }
        CAN_ALL_INTERFACES = new CanInterface(0);
        CAN_MTU = CanSocket._fetch_CAN_MTU();
        CAN_FD_MTU = CanSocket._fetch_CAN_FD_MTU();
        CAN_RAW_FILTER = CanSocket._fetch_CAN_RAW_FILTER();
        CAN_RAW_ERR_FILTER = CanSocket._fetch_CAN_RAW_ERR_FILTER();
        CAN_RAW_LOOPBACK = CanSocket._fetch_CAN_RAW_LOOPBACK();
        CAN_RAW_RECV_OWN_MSGS = CanSocket._fetch_CAN_RAW_RECV_OWN_MSGS();
        CAN_RAW_FD_FRAMES = CanSocket._fetch_CAN_RAW_FD_FRAMES();
    }

    public static enum Mode {
        RAW,
        BCM;

    }

    public static final class CanInterface
    implements Cloneable {
        private final int _ifIndex;
        private String _ifName;

        public CanInterface(CanSocket socket, String ifName) throws IOException {
            this._ifIndex = CanSocket._discoverInterfaceIndex(socket._fd, ifName);
            this._ifName = ifName;
        }

        private CanInterface(int ifIndex, String ifName) {
            this._ifIndex = ifIndex;
            this._ifName = ifName;
        }

        private CanInterface(int ifIndex) {
            this(ifIndex, null);
        }

        public int getInterfaceIndex() {
            return this._ifIndex;
        }

        public String toString() {
            return "CanInterface [_ifIndex=" + this._ifIndex + ", _ifName=" + this._ifName + "]";
        }

        public String getIfName() {
            return this._ifName;
        }

        public String resolveIfName(CanSocket socket) {
            if (this._ifName == null) {
                try {
                    this._ifName = CanSocket._discoverInterfaceName(socket._fd, this._ifIndex);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this._ifName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._ifIndex;
            result = 31 * result + (this._ifName == null ? 0 : this._ifName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CanInterface other = (CanInterface)obj;
            if (this._ifIndex != other._ifIndex) {
                return false;
            }
            return !(this._ifName == null ? other._ifName != null : !this._ifName.equals(other._ifName));
        }

        protected Object clone() {
            return new CanInterface(this._ifIndex, this._ifName);
        }
    }

    public static final class CanFrame
    implements Cloneable {
        private final CanInterface canIf;
        private final CanId canId;
        private final byte[] data;

        public CanFrame(CanInterface canIf, CanId canId, byte[] data) {
            this.canIf = canIf;
            this.canId = canId;
            this.data = data;
        }

        private CanFrame(int canIf, int canid, byte[] data) {
            if (data.length > 8) {
                throw new IllegalArgumentException();
            }
            this.canIf = new CanInterface(canIf);
            this.canId = new CanId(canid);
            this.data = data;
        }

        public CanId getCanId() {
            return this.canId;
        }

        public byte[] getData() {
            return this.data;
        }

        public CanInterface getCanInterfacae() {
            return this.canIf;
        }

        public String toString() {
            return "CanFrame [canIf=" + this.canIf + ", canId=" + this.canId + ", data=" + Arrays.toString(this.data) + "]";
        }

        protected Object clone() {
            return new CanFrame(this.canIf, (CanId)this.canId.clone(), Arrays.copyOf(this.data, this.data.length));
        }
    }

    public static final class CanId
    implements Cloneable {
        private int _canId = 0;

        public CanId(int address) {
            this._canId = address;
        }

        public boolean isSetEFFSFF() {
            return CanSocket._isSetEFFSFF(this._canId);
        }

        public boolean isSetRTR() {
            return CanSocket._isSetRTR(this._canId);
        }

        public boolean isSetERR() {
            return CanSocket._isSetERR(this._canId);
        }

        public CanId setEFFSFF() {
            this._canId = CanSocket._setEFFSFF(this._canId);
            return this;
        }

        public CanId setRTR() {
            this._canId = CanSocket._setRTR(this._canId);
            return this;
        }

        public CanId setERR() {
            this._canId = CanSocket._setERR(this._canId);
            return this;
        }

        public CanId clearEFFSFF() {
            this._canId = CanSocket._clearEFFSFF(this._canId);
            return this;
        }

        public CanId clearRTR() {
            this._canId = CanSocket._clearRTR(this._canId);
            return this;
        }

        public CanId clearERR() {
            this._canId = CanSocket._clearERR(this._canId);
            return this;
        }

        public int getCanId_SFF() {
            return CanSocket._getCANID_SFF(this._canId);
        }

        public int getCanId_EFF() {
            return CanSocket._getCANID_EFF(this._canId);
        }

        public int getCanId_ERR() {
            return CanSocket._getCANID_ERR(this._canId);
        }

        protected Object clone() {
            return new CanId(this._canId);
        }

        private Set<StatusBits> _inferStatusBits() {
            EnumSet<StatusBits> bits = EnumSet.noneOf(StatusBits.class);
            if (this.isSetERR()) {
                bits.add(StatusBits.ERR);
            }
            if (this.isSetEFFSFF()) {
                bits.add(StatusBits.EFFSFF);
            }
            if (this.isSetRTR()) {
                bits.add(StatusBits.RTR);
            }
            return Collections.unmodifiableSet(bits);
        }

        public String toString() {
            return "CanId [canId=" + (this.isSetEFFSFF() ? this.getCanId_EFF() : this.getCanId_SFF()) + "flags=" + this._inferStatusBits() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._canId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CanId other = (CanId)obj;
            return this._canId == other._canId;
        }

        public static enum StatusBits {
            ERR,
            EFFSFF,
            RTR;

        }
    }
}

