/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.common.Sensor;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;

public abstract class Sensor14bits
implements Sensor,
SensorPluggedOnTTC580 {
    private static final Logger FCSLOG = Logger.getLogger(Sensor14bits.class.getName());
    @LookupName
    protected String name;
    protected int value = 0;
    private volatile boolean updatingValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition valueUpdated = this.lock.newCondition();

    @Override
    public int getValue() {
        this.lock.lock();
        try {
            while (this.updatingValue) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.log(Level.SEVERE, this.name, ex);
                }
            }
            int n = this.value;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void updateValue() {
        this.lock.lock();
        try {
            this.updatingValue = true;
            int newValue = this.readNewValue();
            if (newValue < 0 || newValue > Short.MAX_VALUE) {
                throw new SensorValueOutOfRangeException("ERROR in Sensor14bits during updateValue for ", this.name, 0, Short.MAX_VALUE, newValue);
            }
            this.value = newValue;
        }
        finally {
            this.updatingValue = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns the value of the sensor stored in FCS memory. Doesn't read again the ADC device.")
    public String printValue() {
        return Integer.toString(this.value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a printed format of this sensor.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/returned value=");
        sb.append(Integer.toString(this.value));
        return sb.toString();
    }
}

