/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerLatch;
import org.lsst.ccs.subsystems.fcs.AutochangerMain;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class AutochangerOnlineClampsTest
extends CcsTestCaseTemplate {
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerLatch latchXminus;
    private static AutochangerLatch latchXplus;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;
    private static SimuEPOSController onlineClampXminusController;
    private static AutochangerOnlineClamp[] clampsList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*************************************************************");
        System.out.println("    TESTS OF AUTOCHANGER ONLINE CLAMPS IN STANDALONE MODE    ");
        System.out.println("*************************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.autochanger.standalone", "true");
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"Autochanger", (String)"serialNB:<alias>,controller:defaultInitial|<alias>", (String)"autochanger-simu");
        autochangerSubsystem.startAgent();
        ((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMain)lookup.getTopComponentNode().getComponent();
        autochanger = (Autochanger)lookup.getComponentByPath("autochanger");
        autochanger.updateStateWithSensors();
        trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByPath("acSensorsGateway");
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePositionAndPublish();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        latches = (AutochangerTwoLatches)lookup.getComponentByPath("latches");
        latchXminus = (AutochangerLatch)lookup.getComponentByPath("latchXminus");
        latchXplus = (AutochangerLatch)lookup.getComponentByPath("latchXplus");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByPath("onlineClamps");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampYminus");
        onlineClampXminusController = (SimuEPOSController)lookup.getComponentByPath(onlineClampXminus.getControllerName());
        clampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus};
        Assert.assertEquals((String)"onlineClampXminusController.getName()=onlineClampXminus.getControllerName()", (Object)onlineClampXminusController.getName(), (Object)onlineClampXminus.getControllerName());
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.allDevicesBooted());
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.configureController();
            Assert.assertTrue((String)"After configuration, clamps should be ready", (boolean)clamp.myDevicesReady());
        }
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("****************************************************");
        System.out.println("***********  BEFORE EACH TEST    *******************");
        System.out.println("****************************************************");
        System.out.println("***go back to initial conditions: autochanger empty at HANDOFF");
        System.out.println("simulateAutochangerTrucksIsAtHandoff");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.setIncrementCurrentToClose(300);
            clamp.setIncrementCurrentToOpen(300);
            clamp.setIncrementCurrentToClamp(532);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
            clamp.setTargetPositionToClose(99000);
            clamp.setTargetPositionToOpen(2000);
        }
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePositionAndPublish();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        System.out.println("simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXminus should be empty", (boolean)latchXminus.isEmpty());
        Assert.assertTrue((String)"latchXplus should be empty", (boolean)latchXplus.isEmpty());
        Assert.assertTrue((String)"Autochanger latches should be empty", (boolean)latches.isEmpty());
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("simulateAutochangerAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        System.out.println("simulateAutochangerOnlineClampsAreUnlocked");
        plutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isOpened());
        Assert.assertTrue((String)"ONLINE clamps are OPENED", (boolean)onlineClamps.isOpened());
        ((AlertService)autochangerSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
    }

    public void test_close_open_onlineClamp() {
        System.out.println("*****************************************");
        System.out.println("*** test_close_open_onlineClamp       ***");
        System.out.println("*****************************************");
        Assert.assertTrue((String)"Online clamps are OPENED", (boolean)onlineClamps.isOpened());
        Assert.assertTrue((String)"onlineClampXminusController is initialized", (boolean)onlineClampXminusController.isInitialized());
        Assert.assertTrue((String)"onlineClampXminus hardware is ready", (boolean)onlineClampXminus.myDevicesReady());
        Assert.assertTrue((String)"onlineClampXminus is initialized", (boolean)onlineClampXminus.isInitialized());
        Assert.assertTrue((String)"ONLINE clamps hardware is ready", (boolean)onlineClamps.myDevicesReady());
        Assert.assertTrue((String)"ONLINE clamps is initialized", (boolean)onlineClamps.isInitialized());
        System.out.println("*** test method close of class AutochangerOnlineClampModule - test with onlineClampXminus");
        System.out.println("*** test close onlineClampXminus  - should fail because autochanger trucks are at HANDOFF");
        try {
            onlineClampXminus.closeClampInCurrentMode();
            Assert.fail((String)"autochanger is at HANDOFF - can't close clamps. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        trucks.updatePositionAndPublish();
        System.out.println("*** test close onlineClampXminus again - should fail because autochanger is empty");
        try {
            onlineClampXminus.closeClampInCurrentMode();
            Assert.fail((String)"onlineClampXminus can't be CLOSED if there is no filter in autochanger trucks. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isClosed());
        System.out.println("*** test close the 3 onlineClamps - should success");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.closeClampInCurrentMode();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getFinalCurrentToClose() ? 1 : 0) != 0);
        }
        System.out.println("*** test close onlineClampXminus again - should do nothing but log.");
        onlineClampXminus.closeClampInCurrentMode();
        Assert.assertTrue((String)"onlineClampXminus is CLOSED", (boolean)onlineClampXminus.isClosed());
        Assert.assertTrue((onlineClampXminus.getSentCurrent() == onlineClampXminus.getFinalCurrentToClose() ? 1 : 0) != 0);
        System.out.println("*** test open onlineClamps");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.openClampInCurrentMode();
            Assert.assertTrue((String)(clamp.getName() + " is OPENED"), (boolean)clamp.isOpened());
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
    }

    public void test_lock_unlock_onlineClamp() {
        System.out.println("*****************************************");
        System.out.println("*** test_lock_unlock_onlineClamp");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isClosed());
        AutochangerOnlineClamp clampToTest = onlineClampYminus;
        try {
            clampToTest.closeClampInCurrentMode();
            Assert.fail((String)"clampToTest.close() should fail because autochanger is not ONLINE.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.closeClampInCurrentMode();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
        }
        clampToTest = onlineClampXminus;
        try {
            clampToTest.closeClampInCurrentMode();
            Assert.fail((String)(clampToTest.getName() + " can't be closed because it's locked. It has to be unlocked."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        clampToTest = onlineClampXplus;
        try {
            clampToTest.openClampInCurrentMode();
            Assert.fail((String)(clampToTest.getName() + " can't be opened because it's locked. It has to be unlocked first."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        System.out.println("*** open again onlineClamps");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.openClampInCurrentMode();
            Assert.assertTrue((String)(clamp.getName() + " is OPENED"), (boolean)clamp.isOpened());
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
    }

    public void testCloseClamp() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        System.out.println("onlineClampXplus.getTargetPositionToClose()=" + onlineClampXplus.getTargetPositionToClose());
        onlineClampXplus.close();
        Assert.assertTrue((String)"onlineClampXplus is closed", (boolean)onlineClampXplus.isClosed());
    }

    public void testOpenClamp() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        plutoGateway.simulateAutochangerOnlineClampsAreClosed();
        System.out.println("onlineClampXplus.getTargetPositionToOpen()=" + onlineClampXplus.getTargetPositionToOpen());
        onlineClampXplus.open();
        Assert.assertTrue((String)"onlineClampXplus is opened", (boolean)onlineClampXplus.isOpened());
    }

    public void testLockClamp() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        plutoGateway.simulateAutochangerOnlineClampsAreClosed();
        onlineClampXplus.lock();
        Assert.assertTrue((String)"onlineClampXplus is locked", (boolean)onlineClampXplus.isLocked());
    }

    public void testUnlockClamp() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        onlineClampXplus.unlock();
        Assert.assertFalse((String)"onlineClampXplus is locked", (boolean)onlineClampXplus.isLocked());
    }

    public void testCloseClamps() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        plutoGateway.simulateAutochangerOnlineClampsAreOpened();
        onlineClamps.closeClamps();
        Assert.assertTrue((String)"onlineClamps is closed", (boolean)onlineClamps.isClosed());
    }

    public void testLockClamps() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        plutoGateway.simulateAutochangerOnlineClampsAreClosed();
        onlineClamps.lockClamps();
        Assert.assertTrue((String)"onlineClamps is locked", (boolean)onlineClamps.isLocked());
    }

    public void testUnlockClamps() {
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        onlineClamps.unlockClamps();
        Assert.assertTrue((String)"onlineClamps is closed", (boolean)onlineClamps.isClosed());
    }

    @Test
    public void testExecuteCurrentRamp() throws Exception {
        System.out.println("*****************************************");
        System.out.println("***   test executeCurrentRamp         ***");
        System.out.println("*****************************************");
        int initialValue = 0;
        int finalValue = 2000;
        int increment = 250;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment);
        int readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 0;
        finalValue = -2000;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 2000;
        finalValue = 0;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 300;
        finalValue = 3000;
        increment = 300;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
    }

    public void testOpenClampsX() {
        System.out.println("*****************************************");
        System.out.println("***   test openClampsX        ***");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        onlineClamps.openClamps();
        for (AutochangerOnlineClamp clamp : new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus}) {
            Assert.assertTrue((String)(clamp.getName() + " is open "), (boolean)clamp.isOpened());
            Assert.assertTrue((String)(clamp.getName() + " sentCurrent is currentToOpen"), (clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
        System.out.println("***   end of test openClampsX         ***");
    }

    public void testCloseClampsX() {
        System.out.println("*****************************************");
        System.out.println("***   test closeClampsX        ***");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        onlineClamps.closeClamps();
        for (AutochangerOnlineClamp clamp : new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus}) {
            Assert.assertTrue((String)(clamp.getName() + " is closed "), (boolean)clamp.isClosed());
            Assert.assertTrue((String)(clamp.getName() + " sentCurrent is finalCurrentToClose"), (clamp.getSentCurrent() == clamp.getFinalCurrentToClose() ? 1 : 0) != 0);
        }
        System.out.println("***   end of test closeClampsX         ***");
    }

    @AfterClass
    public static void after() throws Exception {
        System.getProperties().remove("org.lsst.ccs.fcs.instance.autochanger.standalone");
        if (autochangerSubsystem != null) {
            autochangerSubsystem.shutdownAgent();
            ((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        }
    }
}

