/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerLatch;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerTwoLatches
implements AlertRaiser,
SignalHandler,
HasLifecycle {
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    private final AutochangerLatch latchXminus;
    private final AutochangerLatch latchXplus;
    private volatile FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.UNKNOWN;

    public AutochangerTwoLatches(AutochangerLatch latchXminus, AutochangerLatch latchXplus) {
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerTwoLatches.class, this.path);
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 2 latches are initialized.")
    public boolean isInitialized() {
        return this.latchXminus.isInitialized() && this.latchXplus.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are CLOSED.")
    public boolean isClosed() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.CLOSED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are OPENED.")
    public boolean isOpened() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.OPENED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the latches is in ERROR state.")
    public boolean isInError() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    private boolean isInTravel() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if there is no filter is latches.")
    public boolean isEmpty() {
        return this.latchXminus.isEmpty() && this.latchXplus.isEmpty();
    }

    public boolean isFilterEngagedInError() {
        return this.latchXminus.isFilterEngagedInError() || this.latchXplus.isFilterEngagedInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if autochanger is holding a filter.")
    public boolean isHoldingFilter() {
        return this.isFilterEngaged() && this.isClosed();
    }

    private boolean isFilterEngaged() {
        return !this.latchXminus.isEmpty() && !this.latchXplus.isEmpty();
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.latchXminus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, "latchXminus");
        this.latchXplus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, "latchXplus");
        if (this.latchXminus.getLockStatus() != this.latchXplus.getLockStatus()) {
            String msg = this.name + " sensors are in ERROR: latchXminus state=" + this.latchXminus.getLockStatus() + " latchXplus state=" + this.latchXplus.getLockStatus();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(this.name + " LockStatus is different on both side. Can't close neither open latches.");
        }
        if (this.latchXminus.isEmpty() != this.latchXplus.isEmpty()) {
            String msg = this.name + " Error in filterPresenceSensors of autochanger : the 2 sensors send different values. latchXminus.isEmpty=" + this.latchXminus.isEmpty() + " latchXplus.isEmpty=" + this.latchXplus.isEmpty();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(msg + "Can't close neither open latches.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-latches");){
            AutochangerTwoLatches autochangerTwoLatches = this;
            synchronized (autochangerTwoLatches) {
                this.latchXminus.updateState();
                this.latchXplus.updateState();
                this.computeLockStatus();
                this.computeFilterPresenceStatus();
            }
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
    }

    private void computeFilterPresenceStatus() {
        this.filterPresenceStatus = this.latchXminus.isEmpty() != this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.ERROR : (this.isEmpty() ? FcsEnumerations.FilterPresenceStatus.NOFILTER : (this.isFilterEngaged() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.UNKNOWN));
    }

    public void close() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("closeLatches");){
            FcsUtils.parallelRun(() -> this.latchXminus.close(), () -> this.latchXplus.close());
        }
    }

    public void open() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openLatches");){
            FcsUtils.parallelRun(() -> this.latchXminus.open(), () -> this.latchXplus.open());
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize autochanger latches hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.latchXminus.postStart();
        this.latchXplus.postStart();
    }

    public StatusDataPublishedByAutochangerTwoLatches createStatusDataPublishedByTwoLatches() {
        StatusDataPublishedByAutochangerTwoLatches status = new StatusDataPublishedByAutochangerTwoLatches();
        status.setLockStatus(this.lockStatus);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterName(this.autochanger.getFilterOnTrucksName());
        status.setFilterId(this.autochanger.getFilterID());
        status.setAvailable(this.autochanger.isAvailable());
        return status;
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByTwoLatches()));
    }
}

