package org.lsst.ccs.subsystems.fcs.common;

/**
 *
 * @author virieux
 */
public interface TTC580Interface extends PieceOfHardware {

    short getSocketId(long pdo);

    /**
     *
     * @return first pdo sent by this device
     */
    default long getPdo1() {
        return 0;
    }

    /**
     *
     * @return second pdo sent by this device
     */
    default long getPdo2() {
        return 0;
    }

    /**
     *
     * @return second pdo sent by this device
     */
    default long getPdo4() {
        return 0;
    }

    /**
     * read SDO which holds offsets for presence sensors of clampXminus and
     * clampXplus
     *
     * @param s
     * @return SDO
     */
    long readOffset1SDO(byte s);

    /**
     * read SDO which holds offsets for lock sensors of clampXminus and clampXplus
     *
     * @param s
     * @return
     */
    long readOffset2SDO(byte s);

    /**
     * read SDO which contains OUT interlocks for autochanger (OUT signals CS,
     * CFC, CF1, CF0)
     *
     * @return SDO
     */
    long readInterlocksSDO();

    /**
     * read SDO 6404 index 5 to find lock threshold value for all carousel
     * clamps. This value depends on ambient temperature.
     *
     * @return
     */
    long readLockSensorMinLocked();

    /**
     * The mean of the temperatures on the 10 clamps can be read on hyttc580 os
     * SDO 6404 index 4. Dixit Claire Juramy.
     *
     * @return
     */
    double readMeanClampsTemperature();

    double readInternalTemperature();

    void interlockShutterDisable();

    void interlockShutterEnable();

    void checkTTC580Temperatures();

    int readSlipRingCurrent();
}
