/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class CarouselSocket
implements HasLifecycle,
AlertRaiser {
    private static final Logger FCSLOG = Logger.getLogger(CarouselSocket.class.getName());
    private int id;
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Carousel carousel;
    private CarouselClamp clampXminus;
    private CarouselClamp clampXplus;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected SensorPluggedOnTTC580 ioModuleSensor;
    protected FcsEnumerations.IOModuleStatus ioModuleStatus;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="autochanger")
    protected FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @ConfigurationParameter(range="-4500000..4500000", description=" carousel position when this socket is at standby [carousel encoder step]", units="unitless", category="carousel")
    private volatile int standbyPosition;
    @ConfigurationParameter(range="-2000..2000", description="autochanger delta STANDBY position to be used to store a filter on carousel on this socket", units="micron", category="carousel")
    private volatile int deltaAutochangerStandbyPosition = 0;
    private int deltaPosition = 0;
    @Persist
    public volatile int filterID;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    @Persist
    private volatile boolean available = true;
    private Map<FcsEnumerations.MobileItemAction, PersistentCounter> movementCounter;

    public CarouselSocket(int id, CarouselClamp clampXminus, CarouselClamp clampXplus) {
        this.id = id;
        this.clampXminus = clampXminus;
        this.clampXplus = clampXplus;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarouselSocket.class, this.path);
        this.movementCounter = new EnumMap<FcsEnumerations.MobileItemAction, PersistentCounter>(FcsEnumerations.MobileItemAction.class);
        for (FcsEnumerations.MobileItemAction action : new FcsEnumerations.MobileItemAction[]{FcsEnumerations.MobileItemAction.UNLOCK_CLAMPS, FcsEnumerations.MobileItemAction.RELEASE_CLAMPS}) {
            this.registerActionDuration(action);
            this.movementCounter.put(action, PersistentCounter.newCounter(action.getActionCounterPath(this.path), this.subs, action.name()));
        }
    }

    public void registerActionDuration(FcsEnumerations.MobileItemAction action) {
        String path = this.getActionDurationPath(action.name());
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.getActionDurationPath(action.name()), (Serializable)Integer.valueOf(0)));
        DataProviderInfo info = this.dataProviderDictionaryService.getDataProviderDictionary().getDataProviderInfoForPath(path);
        info.addAttribute(DataProviderInfo.Attribute.UNITS, "millisecond");
        info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Duration of action " + action.name());
    }

    public String getActionDurationPath(String actionName) {
        return "duration/" + this.path + "/" + actionName;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CarouselClamp getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(CarouselClamp clampXminus) {
        this.clampXminus = clampXminus;
    }

    public CarouselClamp getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(CarouselClamp clampXplus) {
        this.clampXplus = clampXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns filterID if a filter is in the socket.")
    public int getFilterID() {
        return this.filterID;
    }

    public String getFilterName() {
        return this.filterManager.getFilterNameByID(this.filterID);
    }

    public String getFilterObservatoryName() {
        return this.filterManager.getFilterNameByID(this.filterID);
    }

    public void setFilterID(int filterID) {
        int formerFilterID = this.filterID;
        if (formerFilterID == filterID) {
            FCSLOG.fine(() -> this.name + " filter " + this.getFilterName() + " already on socket" + this.getId());
        } else {
            this.filterID = filterID;
            this.subs.getAgentPersistenceService().persistNow();
            this.publishData();
            FCSLOG.info(() -> this.name + " switching from filter " + this.filterManager.getFilterNameByID(formerFilterID) + " to filter " + this.getFilterName());
        }
    }

    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    public int getDeltaPosition() {
        return this.deltaPosition;
    }

    public int getDeltaAutochangerStandbyPosition() {
        return this.deltaAutochangerStandbyPosition;
    }

    public FcsEnumerations.IOModuleStatus getIOModuleStatus() {
        return this.ioModuleStatus;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this socket is at STANDBY position on the carousel.")
    public boolean isAtStandby() {
        return this.carousel.getSocketAtStandbyID() == this.id;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if socket is ready to use or false if not.")
    public boolean isAvailable() {
        return this.available;
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Set boolean available to true if socket is ready to use or false if not. If available is false, this command should be used to return to 'available' only after FES engineers have been consulted.")
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Flag the carousel socket as NOT READY TO USE. If the socket holds a filter, it will prevent it from being used and will disappear from the list of available filters. This is a protective command that can do no harm but will give some time to FES experts to review the status of the socket before deciding to reactivate it.")
    public void setUnavailable() {
        this.setAvailable(false);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if socket is awake (ioModuleStatus different from NOT_POWERED_ON or BOOTING)")
    public boolean isAwake() {
        if (!this.isAvailable()) {
            FCSLOG.info(this.name + " socket not available, skipping test");
            return true;
        }
        FCSLOG.info(this.name + " ioModuleStatus = " + this.ioModuleStatus);
        return !this.ioModuleStatus.equals(FcsEnumerations.IOModuleStatus.NOT_POWERED_ON) && !this.ioModuleStatus.equals(FcsEnumerations.IOModuleStatus.BOOTING);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if socket clamps are responsive (filterPresence > 0)")
    public boolean areClampsResponsive() {
        if (!this.isAvailable()) {
            FCSLOG.info(this.name + " socket not available, skipping test");
            return true;
        }
        return this.clampXminus.isResponsive() && this.clampXplus.isResponsive();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if socket clamps are stabilised (providing normal clamp state)")
    public boolean areClampsStateStabilised() {
        if (!this.isAvailable()) {
            FCSLOG.info(this.name + " socket not available, skipping test");
            return true;
        }
        return this.clampXminus.isStabilised() && this.clampXplus.isStabilised();
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR.getAlert(this.name), alwaysClear);
        this.clampXminus.setController(this.clampXminusController);
        this.clampXplus.setController(this.clampXplusController);
    }

    private boolean isAutochangerHoldingFilter() {
        return this.autochanger.isAtStandby() && this.autochanger.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.clampXminusController.isInitialized() && this.clampXplusController.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return clamps state - doesn't read again sensors.")
    public FcsEnumerations.FilterClampState getClampsState() {
        return this.clampsState;
    }

    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-carouselSocket");){
            this.ioModuleStatus = this.ioModuleSensor.getValue() >= 1 && this.ioModuleSensor.getValue() <= 7 ? FcsEnumerations.IOModuleStatus.getStatusByCode(this.ioModuleSensor.getValue()) : FcsEnumerations.IOModuleStatus.UNKNOWN_STATUS;
            if (this.ioModuleSensor.getValue() < 4 && this.ioModuleSensor.getValue() > 0) {
                this.updateClampsState();
            } else {
                this.clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
                if (this.isAvailable() && !this.carousel.isAsleep()) {
                    FCSLOG.info(this.name + " IO module status = " + this.ioModuleSensor.getValue() + " => " + this.ioModuleStatus + ", slip ring current = " + this.carousel.readSlipRingCurrent() + "mA");
                    this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " IO module status = " + this.ioModuleSensor.getValue() + " => " + this.ioModuleStatus, this.name);
                }
            }
            this.updateDeltaPosition();
            this.publishData();
        }
    }

    public synchronized void updateDeltaPosition() {
        this.deltaPosition = this.carousel.getPosition() - this.standbyPosition % this.carousel.getFullTurn();
    }

    private void updateClampsState() {
        boolean inError;
        this.clampXminus.updateState();
        this.clampXplus.updateState();
        boolean bl = inError = this.clampXminus.getClampState() == FcsEnumerations.FilterClampState.ERROR || this.clampXplus.getClampState() == FcsEnumerations.FilterClampState.ERROR;
        if (this.clampXminus.getClampState() == this.clampXplus.getClampState()) {
            this.clampsState = this.clampXminus.getClampState();
            FCSLOG.finer(() -> this.name + " : clamps are updated");
        } else if (this.clampXminus.getClampState() == FcsEnumerations.FilterClampState.UNCLAMPED_EMPTY && this.clampXplus.getClampState() == FcsEnumerations.FilterClampState.READY_TO_CLAMP) {
            this.clampsState = !this.clampXminus.getController().isInState(EPOSEnumerations.EposState.OPERATION_ENABLE) && !this.clampXplus.getController().isInState(EPOSEnumerations.EposState.OPERATION_ENABLE) ? FcsEnumerations.FilterClampState.READY_TO_CLAMP : FcsEnumerations.FilterClampState.UNCLAMPED_EMPTY;
        } else if (!inError) {
            FCSLOG.fine(() -> this.name + " clampXminus is " + this.clampXminus.getClampState() + " and clampXplus is " + this.clampXplus.getClampState() + " clampState = " + FcsEnumerations.FilterClampState.UNDEFINED);
            this.clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
        } else {
            this.clampsState = FcsEnumerations.FilterClampState.ERROR;
            if (this.isAvailable()) {
                String msg2 = this.name + ": clampState at Xminus side is different from clampState at Xplus side. ";
                msg2 = msg2 + this.clampXminus.getName() + " state=" + this.clampXminus.getClampState() + " ";
                msg2 = msg2 + this.clampXplus.getName() + " state=" + this.clampXplus.getClampState();
                this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, msg2, this.name);
            }
        }
        if (this.isAvailable() && !this.carousel.isAsleep()) {
            this.clampXminus.getSensorErrorCounter().forEach(msg -> this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, (String)msg, this.name));
            this.clampXplus.getSensorErrorCounter().forEach(msg -> this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, (String)msg, this.name));
        }
    }

    public void updateFilterID() {
        if (this.isEmpty()) {
            this.setFilterID(0);
        } else if (this.autochanger.isAtStandby()) {
            this.setFilterID(this.autochanger.getFilterID());
        }
        FCSLOG.finer(() -> this.name + " filter ID = " + this.carousel.getSocketAtStandby().getFilterID());
    }

    public void checkAndUpdateOffset1(long sdo) {
        this.clampXminus.checkAndUpdateOffset1(TTC580Utils.getOffset1Xminus(sdo));
        this.clampXplus.checkAndUpdateOffset1(TTC580Utils.getOffset1Xplus(sdo));
    }

    public void checkAndUpdateOffset2(long sdo) {
        this.clampXminus.checkAndUpdateOffset2(TTC580Utils.getOffset2Xminus(sdo));
        this.clampXplus.checkAndUpdateOffset2(TTC580Utils.getOffset2Xplus(sdo));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is no filter in the socket.")
    public boolean isEmpty() {
        return this.clampXminus.getFilterPresenceStatus() == FcsEnumerations.FilterPresenceStatus.NOFILTER && this.clampXplus.getFilterPresenceStatus() == FcsEnumerations.FilterPresenceStatus.NOFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare LOCKED.")
    public boolean isClampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.CLAMPED_ON_FILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPED_ON_FILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is NO filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedEmpty() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPED_EMPTY;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if this socket is ready to clamp a filter.")
    public boolean isReadyToClamp() {
        return this.clampsState == FcsEnumerations.FilterClampState.READY_TO_CLAMP;
    }

    private void releaseClamps(boolean forRecovery) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("socket-releaseClamps");){
            this.carousel.updateStateWithSensors();
            FCSLOG.info("Checking conditions for release clamp " + this.name + " on socket at standby position.");
            if (!this.isAtStandby()) {
                throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
            }
            if (!forRecovery) {
                if (this.clampXminus.isFilterEngaged() || this.clampXplus.isFilterEngaged()) {
                    throw new RejectedCommandException(this.name + ": Can't release clamps because a filter is engaged in clamps.");
                }
                FCSLOG.info(this.name + ": Releasing clamps at standby position.");
            } else {
                FCSLOG.info(this.name + ": Releasing clamps with the filter still present, used only during recovery.");
            }
            FcsUtils.parallelRun(() -> this.clampXminus.release(), () -> this.clampXplus.release());
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release the 2 clamps of this socket if the socket is at STANDBY position.")
    public void releaseClamps() {
        this.releaseClamps(false);
    }

    public void recoveryReleaseClamps() {
        this.releaseClamps(true);
        this.carousel.recoveryLockingXminus();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the 2 clamps of this socket if the socket is at STANDBY position.")
    public void unlockClamps() {
        if (!this.carousel.isUnclampAllowedByPLC()) {
            throw new RejectedCommandException(this.name + " PLC does not allow to unlock clamps. Check PLCCarouselPanel.");
        }
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("socket-unlockClamps");){
            this.carousel.updateStateWithSensors();
            if (!this.isAtStandby()) {
                throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
            }
            if (!this.isEmpty() && !this.isAutochangerHoldingFilter()) {
                throw new RejectedCommandException(this.name + "cannot unlock clamps if NOT EMPTY and FILTER is NOT HELD by autochanger.");
            }
            FcsUtils.parallelRun(() -> this.clampXminus.unlock(), () -> this.clampXplus.unlock());
            FCSLOG.info("Command unlockClamps completed");
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns a String representation of a CarouselSocket")
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("= " + this.name + " =");
        if (!this.isAvailable()) {
            sb.append("!!! NOT AVAILABLE !!!").append("\n");
        }
        String filterStr = this.isEmpty() ? "NONE" : this.getFilterName();
        sb.append("Filter: ").append(filterStr).append("\n");
        sb.append("Filter ID: ").append(this.filterID).append("\n");
        sb.append("At STANDBY: ").append(this.isAtStandby()).append("\n");
        sb.append("Clamp state: ").append(this.clampsState).append("\n");
        sb.append("IO Module status: ").append(this.ioModuleStatus).append("\n");
        sb.append("~~~").append("\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns a string representation of a CarouselSocket and its clamps")
    public synchronized String printSocketInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append(this.clampXminus.toString());
        sb.append(this.clampXplus.toString());
        return sb.toString();
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByCarouselSocket()));
    }

    public StatusDataPublishedByCarouselSocket createStatusDataPublishedByCarouselSocket() {
        StatusDataPublishedByCarouselSocket status = new StatusDataPublishedByCarouselSocket();
        status.setAtStandby(this.isAtStandby());
        status.setIOStatus(this.ioModuleStatus);
        status.setClampsState(this.clampsState);
        status.setEmpty(this.isEmpty());
        status.setFilterID(this.filterID);
        status.setSocketID(this.id);
        status.setAvailable(this.available);
        if (this.isEmpty()) {
            status.setFilterName("NO FILTER");
        } else {
            status.setFilterName(this.getFilterName());
        }
        return status;
    }
}

