/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;

public class CanOpenErrorsTableTest
extends CcsTestCaseTemplate {
    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF READING CANopen errors tables");
        CanOpenErrorsTable.loadCanOpenErrorTables();
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of CanOpenErrorsTable tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetDeviceErrorNameByCode() throws Exception {
        System.out.println("getDeviceErrorNameByCode");
        CanOpenErrorsTable.loadCanOpenErrorTables();
        int aCode = 0;
        String expResult = "No Error";
        String result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"0000 error name", (Object)expResult, (Object)result);
        aCode = 65298;
        expResult = "Auxiliary Sensor Direction Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"FF12 error name", (Object)expResult, (Object)result);
        aCode = 1634578;
        expResult = "18f112= unknown in /maxonMotorDeviceErrors.properties";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"018F112 error name", (Object)expResult, (Object)result);
        aCode = 12832;
        expResult = "Undervoltage Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"0x3220 error name", (Object)expResult, (Object)result);
        aCode = 12832;
        expResult = "Undervoltage Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"3220 error name", (Object)expResult, (Object)result);
        aCode = 3220;
        expResult = "c94= unknown in /maxonMotorDeviceErrors.properties";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"3220 error name", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetErrorRegisterNameByCode() {
        System.out.println("getErrorRegisterNameByCode");
        int aCode = 0;
        String expResult = "no errors";
        String result = CanOpenErrorsTable.getErrorRegisterNameByCode((int)aCode);
        Assert.assertEquals((String)"00 error name", (Object)expResult, (Object)result);
        aCode = 128;
        expResult = "motion error";
        result = CanOpenErrorsTable.getErrorRegisterNameByCode((int)aCode);
        Assert.assertEquals((String)"80 error name", (Object)expResult, (Object)result);
        aCode = 703710;
        expResult = "abcde= unknown in /errorRegister.properties";
        result = CanOpenErrorsTable.getErrorRegisterNameByCode((int)aCode);
        Assert.assertEquals((String)"abcde error name", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetCommErrorNameByCode() {
        System.out.println("getCommErrorNameByCode");
        int aCode = 0;
        String expResult = "No Communication Error";
        String result = CanOpenErrorsTable.getCanopenSDOErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"00000000 error name", (Object)expResult, (Object)result);
        aCode = 251723705;
        expResult = "Error CAN ID";
        result = CanOpenErrorsTable.getCanopenSDOErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"0F00FFB9 error name", (Object)expResult, (Object)result);
        aCode = 0xF00FFBF;
        result = CanOpenErrorsTable.getCanopenSDOErrorNameByCode((int)aCode);
        expResult = "Illegal Command Error";
        Assert.assertEquals((String)"0f00ffbf error name", (Object)expResult, (Object)result);
        aCode = 43981;
        result = CanOpenErrorsTable.getCanopenSDOErrorNameByCode((int)aCode);
        expResult = "abcd= unknown in /canopenSDOErrors.properties";
        Assert.assertEquals((String)"abcd error name", (Object)expResult, (Object)result);
        aCode = 0x6020000;
        result = CanOpenErrorsTable.getCanopenSDOErrorNameByCode((int)aCode);
        expResult = "Object does not exist Wrong Index";
        Assert.assertEquals((String)"0x6020000 error name", (Object)expResult, (Object)result);
    }
}

