/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.internal.CategorizedStatistics;

public class ConcurrentSecondLevelCacheStatisticsImpl
extends CategorizedStatistics
implements SecondLevelCacheStatistics {
    private final transient Region region;
    private final transient EntityRegionAccessStrategy entityRegionAccessStrategy;
    private final transient CollectionRegionAccessStrategy collectionRegionAccessStrategy;
    private AtomicLong hitCount = new AtomicLong();
    private AtomicLong missCount = new AtomicLong();
    private AtomicLong putCount = new AtomicLong();

    ConcurrentSecondLevelCacheStatisticsImpl(Region region, EntityRegionAccessStrategy entityRegionAccessStrategy, CollectionRegionAccessStrategy collectionRegionAccessStrategy) {
        super(region.getName());
        this.region = region;
        this.entityRegionAccessStrategy = entityRegionAccessStrategy;
        this.collectionRegionAccessStrategy = collectionRegionAccessStrategy;
    }

    @Override
    public long getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public long getPutCount() {
        return this.putCount.get();
    }

    @Override
    public long getElementCountInMemory() {
        return this.region.getElementCountInMemory();
    }

    @Override
    public long getElementCountOnDisk() {
        return this.region.getElementCountOnDisk();
    }

    @Override
    public long getSizeInMemory() {
        return this.region.getSizeInMemory();
    }

    @Override
    public Map getEntries() {
        HashMap map = new HashMap();
        Iterator iterator = this.region.toMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            Object id = this.entityRegionAccessStrategy != null ? this.entityRegionAccessStrategy.getCacheKeyId(me.getKey()) : (this.collectionRegionAccessStrategy != null ? this.collectionRegionAccessStrategy.getCacheKeyId(me.getKey()) : me.getKey());
            map.put(id, me.getValue());
        }
        return map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("SecondLevelCacheStatistics").append("[hitCount=").append(this.hitCount).append(",missCount=").append(this.missCount).append(",putCount=").append(this.putCount);
        if (this.region != null) {
            buf.append(",elementCountInMemory=").append(this.getElementCountInMemory()).append(",elementCountOnDisk=").append(this.getElementCountOnDisk()).append(",sizeInMemory=").append(this.getSizeInMemory());
        }
        buf.append(']');
        return buf.toString();
    }

    void incrementHitCount() {
        this.hitCount.getAndIncrement();
    }

    void incrementMissCount() {
        this.missCount.getAndIncrement();
    }

    void incrementPutCount() {
        this.putCount.getAndIncrement();
    }
}

