/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.ocsbridge.states.CameraMotionState;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToLoader;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FcsMain
extends MainModule
implements HasDataProviderInfos {
    private static final long serialVersionUID = 7669526660659959402L;
    private static final Logger FCSLOG = Logger.getLogger(FcsMain.class.getName());
    private static final Duration SETFILTER_MAX_DURATION = Duration.ofSeconds(90L);
    private static final Duration LOAD_UNLOAD_FILTER_MAX_DURATION = Duration.ofSeconds(480L);
    private static final String PUBLICATION_KEY_FOR_MCM = "fcs/mcm";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private BridgeToLoader bridgeToLoader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private volatile FcsEnumerations.TelescopeMountRotatorState tmaAndRotatorMotionStatus = FcsEnumerations.TelescopeMountRotatorState.UNKNOWN;
    private final Predicate<AgentInfo> ocsBridgePredicate = ai -> ai.getAgentProperty("agentType").equals(AgentInfo.AgentType.OCS_BRIDGE.name());
    private int carouselWakeUpDuration = 20;
    private int setFilterFastDuration = 95;
    private int setFilterSlowDuration = 120;
    private int percentage = 0;
    @Persist
    private volatile int previousSocketID = -1;
    private boolean firstMCMpublication = true;
    private Map<FcsEnumerations.GeneralAction, PersistentCounter> movementCounter;
    private AtomicLong lastUpdateStateWithSensors = new AtomicLong(0L);
    private final StatusMessageListener cameraMotionStatusMessageListener = new StatusMessageListener(){
        private final AtomicBoolean isFirstStatusStateChangeNotification = new AtomicBoolean(true);

        public void onStatusMessage(StatusMessage msg) {
            CameraMotionState cameraMotionState;
            StateBundle stateToProcess = null;
            if (this.isFirstStatusStateChangeNotification.getAndSet(false)) {
                stateToProcess = msg.getState();
            } else if (msg instanceof StatusStateChangeNotification) {
                StatusStateChangeNotification stateChange = (StatusStateChangeNotification)msg;
                stateToProcess = stateChange.getNewState().diffState(stateChange.getOldState());
            }
            if (stateToProcess != null && (cameraMotionState = (CameraMotionState)stateToProcess.getState(CameraMotionState.class)) != null) {
                FCSLOG.finer("Camera Motion State received from OCS-Bridge = " + cameraMotionState.name());
                switch (cameraMotionState) {
                    case LOCKED: {
                        FcsMain.this.updateTmaAndRotatorStatus(FcsEnumerations.TelescopeMountRotatorState.LOCKED);
                        break;
                    }
                    case UNLOCKED: {
                        FcsMain.this.updateTmaAndRotatorStatus(FcsEnumerations.TelescopeMountRotatorState.UNLOCKED);
                        break;
                    }
                    default: {
                        FCSLOG.warning(FcsMain.this.name + "Unknown Camera Motion (software lock) state: " + cameraMotionState.name());
                        FcsMain.this.updateTmaAndRotatorStatus(FcsEnumerations.TelescopeMountRotatorState.UNKNOWN);
                    }
                }
            }
        }
    };

    @Override
    public void build() {
        if (this.bridgeToLoader == null) {
            throw new RuntimeException("The FcsMain expected a bridge to the Loader, but none was found.");
        }
        if (this.bridgeToLoader.equals(this.bridge)) {
            throw new RuntimeException("In FcsMain both bridges are the same instance. We expected two different bridges.");
        }
        super.build();
        KeyValueData data = this.getDataForMcm();
        this.dataProviderDictionaryService.registerData(data);
        String mainPath = data.getKey();
        KeyValueDataList dataList = (KeyValueDataList)data.getValue();
        for (KeyValueData d : dataList) {
            String path = mainPath + "/" + d.getKey();
            DataProviderInfo info = this.dataProviderDictionaryService.getDataProviderDictionary().getDataProviderInfoForPath(path);
            String units = "unitless";
            String description = "";
            switch (d.getKey()) {
                case "filter_on_autochanger": {
                    description = "OCS name of the filter currently on the autochanger";
                    break;
                }
                case "filter_previous_socketID": {
                    description = "ID of the socket on which the current filter used to sit";
                    break;
                }
                case "autochanger_trucks_position": {
                    description = "Absolute position of the autochanger trucks";
                    units = "micron";
                    break;
                }
                case "autochanger_trucks_state": {
                    description = "Known autochanger position (STANDBY, HANDOFF, ONLINE) or IN_TRAVEL";
                    break;
                }
                case "setFilter_percentage": {
                    description = "Progress of the setFilter command [%]";
                    break;
                }
                case "proximity": {
                    description = "Value of the autochanger proximity sensor";
                    break;
                }
                default: {
                    units = "unitless";
                    description = "";
                }
            }
            info.addAttribute(DataProviderInfo.Attribute.UNITS, units);
            info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, description);
        }
        this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.UNKNOWN});
    }

    @Override
    public void init() {
        super.init();
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.wholefcs", "fcs");
        this.movementCounter = new EnumMap<FcsEnumerations.GeneralAction, PersistentCounter>(FcsEnumerations.GeneralAction.class);
        for (FcsEnumerations.GeneralAction action : new FcsEnumerations.GeneralAction[]{FcsEnumerations.GeneralAction.SET_FILTER, FcsEnumerations.GeneralAction.SET_FILTER_AT_HANDOFF_FOR_LOADER, FcsEnumerations.GeneralAction.STORE_FILTER_ON_CAROUSEL, FcsEnumerations.GeneralAction.SET_NO_FILTER, FcsEnumerations.GeneralAction.DISENGAGE_FILTER_FROM_CAROUSEL, FcsEnumerations.GeneralAction.LOAD_FILTER, FcsEnumerations.GeneralAction.UNLOAD_FILTER, FcsEnumerations.GeneralAction.CONNECT_LOADER, FcsEnumerations.GeneralAction.DISCONNECT_LOADER}) {
            this.movementCounter.put(action, PersistentCounter.newCounter(action.getCounterPath(), this.subs, action.name()));
            this.registerActionDuration(action.name());
        }
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_LOCKING_ISSUE.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert("carousel"), alwaysClear);
    }

    private void updateTmaAndRotatorStatus(FcsEnumerations.TelescopeMountRotatorState tmaRotatorState) {
        FcsEnumerations.TelescopeMountRotatorState currentMotionStatus = FcsEnumerations.TelescopeMountRotatorState.valueOf(this.tmaAndRotatorMotionStatus.name());
        this.tmaAndRotatorMotionStatus = tmaRotatorState;
        if (!currentMotionStatus.equals((Object)this.tmaAndRotatorMotionStatus)) {
            FCSLOG.info(this.name + String.format(" Registering a Camera Motion State (software lock) change from %s to %s", currentMotionStatus.name(), this.tmaAndRotatorMotionStatus.name()));
        }
    }

    public void postInit() {
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connecting(AgentInfo ... agents) {
                for (AgentInfo agent : agents) {
                    if (!FcsMain.this.ocsBridgePredicate.test(agent)) continue;
                    FcsMain.this.getMessagingAccess().addStatusMessageListener(FcsMain.this.cameraMotionStatusMessageListener, m -> FcsMain.this.ocsBridgePredicate.test(m.getOriginAgentInfo()));
                    break;
                }
            }

            public void disconnecting(AgentInfo agent) {
                if (FcsMain.this.ocsBridgePredicate.test(agent)) {
                    FcsMain.this.getMessagingAccess().removeStatusMessageListener(FcsMain.this.cameraMotionStatusMessageListener);
                    FcsMain.this.updateTmaAndRotatorStatus(FcsEnumerations.TelescopeMountRotatorState.UNKNOWN);
                }
            }
        });
    }

    @Override
    public void postStart() {
        AgentInfo agent;
        Iterator iterator = this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents().iterator();
        if (iterator.hasNext() && this.ocsBridgePredicate.test(agent = (AgentInfo)iterator.next())) {
            ConcurrentMessagingUtils messagingUtils = new ConcurrentMessagingUtils(this.getMessagingAccess());
            CommandRequest cmd = new CommandRequest(agent.getName(), "publishState");
            FCSLOG.info("Requesting the OCS-Bridge to publish its states");
            messagingUtils.sendAsynchronousCommand(cmd);
        }
        if (FcsUtils.isProto()) {
            this.updateTmaAndRotatorStatus(FcsEnumerations.TelescopeMountRotatorState.PROTOTYPE);
        }
    }

    public void shutdown() {
        this.getMessagingAccess().removeStatusMessageListener(this.cameraMotionStatusMessageListener);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Print the current software lock status on the telescope and rotator motion")
    public String getTelescopeSoftwareLockStatus() {
        return this.tmaAndRotatorMotionStatus.name();
    }

    private void registerActionDuration(String actionName) {
        String path = this.getDurationPath(actionName);
        this.dataProviderDictionaryService.registerData(new KeyValueData(path, (Serializable)Integer.valueOf(0)));
        DataProviderInfo info = this.dataProviderDictionaryService.getDataProviderDictionary().getDataProviderInfoForPath(path);
        info.addAttribute(DataProviderInfo.Attribute.UNITS, "millisecond");
        info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Duration of " + actionName);
        info.addAttribute(DataProviderInfo.Attribute.TYPE, "long");
    }

    private String getDurationPath(String actionName) {
        return "duration/" + actionName;
    }

    @Override
    public void updateFCSStateToReady() {
        if (this.carousel.isInitialized() && this.autochanger.isInitialized() && this.loader.isInitialized()) {
            this.updateAgentState(FcsEnumerations.FilterState.READY);
            this.updateAgentState(FcsEnumerations.FilterReadinessState.READY);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Sets the filters state to READY even if some sensors are still missing in autochanger.")
    public void forceFilterReadinessStateToReady() {
        this.updateAgentState(FcsEnumerations.FilterState.READY);
        this.updateAgentState(FcsEnumerations.FilterReadinessState.READY);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.autochanger.isLoaderConnected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.allDevicesBooted();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Disconnect the loader hardware.")
    public void disconnectLoaderCANbus() {
        this.movementCounter.get((Object)FcsEnumerations.GeneralAction.DISCONNECT_LOADER).increment();
        long beginTime = System.currentTimeMillis();
        this.loader.disconnectLoaderCANbus();
        this.publishActionDuration(FcsEnumerations.GeneralAction.DISCONNECT_LOADER, System.currentTimeMillis() - beginTime);
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the loader hardware.")
    public void connectLoaderCANbus() {
        this.movementCounter.get((Object)FcsEnumerations.GeneralAction.CONNECT_LOADER).increment();
        long beginTime = System.currentTimeMillis();
        this.loader.connectLoaderCANbus();
        this.publishActionDuration(FcsEnumerations.GeneralAction.CONNECT_LOADER, System.currentTimeMillis() - beginTime);
        this.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return the list of LOADER CANopen hardware that this subsystem manages.")
    public List<String> listLoaderHardwareNames() {
        return this.bridgeToLoader.listHardwareNames();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return the list of names of sensors plugged on Loader pluto gateway.")
    public List<String> listLoSensorsNames() {
        return this.bridgeToLoader.listLoSensorsNames();
    }

    public boolean isFilterInCamera(int filterID) {
        return this.carousel.isFilterOnCarousel(filterID) || this.autochanger.isFilterOnAC(filterID);
    }

    public boolean isFilterAvailable(int filterID) {
        return this.getAvailableFilterMap().entrySet().stream().anyMatch(e -> (Integer)e.getKey() == filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Store the filter on a given socket of the carousel and move the empty autochanger to HANDOFF position.", autoAck=false, timeout=60000)
    public void storeFilterOnSocket(String socketName) {
        this.storeFilterOnSocket(socketName, true);
    }

    private void storeFilterOnSocket(String socketName, boolean withPrecision) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("storeFilterOnSocket");){
            this.updateStateWithSensors();
            if (withPrecision) {
                FCSLOG.info(this.name + " === About to store filter on carousel and to handoff for loader ===");
            } else {
                FCSLOG.info(this.name + " === About to store filter on carousel ===");
            }
            this.movementCounter.get((Object)FcsEnumerations.GeneralAction.STORE_FILTER_ON_CAROUSEL).increment();
            long beginTime = System.currentTimeMillis();
            if (!FcsEnumerations.FilterReadinessState.READY.equals((Object)this.getFilterReadinessState())) {
                throw new RejectedCommandException(this.name + " FilterReadinessState must be READY");
            }
            if (!this.autochanger.isAvailable()) {
                throw new RejectedCommandException(this.name + " the autochanger is currently unavailable");
            }
            CarouselSocket desiredSocket = this.carousel.getSocketByName(socketName);
            if (!desiredSocket.isAvailable()) {
                throw new RejectedCommandException(this.name + " " + socketName + " is unavailable");
            }
            if (desiredSocket != this.carousel.getSocketAtStandby() && !this.carousel.isAvailable()) {
                throw new RejectedCommandException(this.name + " the carousel rotation is currently unavailable");
            }
            if (!this.autochanger.isAtStandby() && this.autochanger.isHoldingFilter() && !desiredSocket.isEmpty()) {
                throw new RejectedCommandException(this.name + " the target carousel socket is not empty");
            }
            FCSLOG.info(this.name + " === About to store filter on carousel ===");
            if (this.autochanger.isAtOnline()) {
                AutochangerThreeOnlineClamps onlineClamps = this.autochanger.getOnlineClamps();
                if (onlineClamps.isLocked()) {
                    onlineClamps.unlockClamps();
                }
                if (onlineClamps.isClosed()) {
                    if (onlineClamps.isHomingDone()) {
                        onlineClamps.openClampsNoXBrakes();
                    } else {
                        onlineClamps.homingFusion();
                    }
                }
                this.updateStateWithSensors();
                if (onlineClamps.isOpened()) {
                    FCSLOG.info(this.name + " === autochanger is free to move ===");
                } else {
                    throw new FcsHardwareException(this.name + " autochanger online clamps should be opened");
                }
            }
            this.carousel.rotateSocketToStandby(socketName);
            this.carousel.checkDeltaPosition();
            FCSLOG.info(this.name + " === carousel is ready to receive a filter at standby ===");
            if (!this.autochanger.isEmpty()) {
                this.autochanger.moveFilterToStandbyPlusDelta(this.carousel.getSocketAtStandby().getDeltaAutochangerStandbyPosition());
                this.updateStateWithSensors();
            }
            if (this.carousel.isHoldingFilterAtStandby()) {
                FCSLOG.info("=== carousel is CLAMPED_ON_FILTER === ");
                this.carousel.getSocketAtStandby().updateFilterID();
                FCSLOG.info("filter ID on CAROUSEL at STANDBY " + this.carousel.getSocketAtStandby().getFilterID());
                FCSLOG.info("filter ID on autochanger = " + this.autochanger.getFilterID());
                FCSLOG.info("==================================");
            } else {
                this.recoveryLockingProcess();
                if (this.carousel.isHoldingFilterAtStandby()) {
                    this.carousel.getSocketAtStandby().updateFilterID();
                } else {
                    String msg = this.name + ": carousel should be CLAMPED_ON_FILTER when autochanger is at STANDBY with a filter; recovery process didn't work";
                    this.raiseAlarm(FcsEnumerations.FcsAlert.CA_LOCKING_ISSUE, msg, this.name);
                    throw new FcsHardwareException(msg);
                }
            }
            if (this.autochanger.isAtStandby()) {
                this.autochanger.waitForProtectionSystemUpdate();
                FCSLOG.info(this.name + ": is going to moveEmptyFromStandbyToHandoff");
                this.autochanger.moveEmptyFromStandbyToHandoff(withPrecision);
            } else {
                this.autochanger.goToHandOff();
            }
            this.publishActionDuration(FcsEnumerations.GeneralAction.STORE_FILTER_ON_CAROUSEL, System.currentTimeMillis() - beginTime);
        }
    }

    private void storeFilterOnCarouselRelaxed() {
        this.storeFilterOnCarousel(false);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Store the filter in the carousel and move the empty autochanger to HANDOFF position for loader. Initial State for autochanger: a filter at HANDOFF or ONLINE. Final State for autochanger : empty at HANDOFF for loader.", autoAck=false, timeout=60000)
    public void storeFilterOnCarousel() {
        this.storeFilterOnCarousel(true);
    }

    private void storeFilterOnCarousel(boolean withPrecision) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("storeFilterOnCarousel");){
            this.updateStateWithSensors();
            if (withPrecision) {
                FCSLOG.info(this.name + " === About to store filter on carousel and go to handoff for loader===");
            } else {
                FCSLOG.info(this.name + " === About to store filter on carousel and go to handoff ===");
            }
            long beginTime = System.currentTimeMillis();
            this.movementCounter.get((Object)FcsEnumerations.GeneralAction.STORE_FILTER_ON_CAROUSEL).increment();
            if (!FcsEnumerations.FilterReadinessState.READY.equals((Object)this.getFilterReadinessState())) {
                throw new RejectedCommandException(this.name + " FilterReadinessState must be READY");
            }
            if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
                throw new RejectedCommandException(this.name + " carousel should be at standby with an empty and available socket");
            }
            if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                throw new RejectedCommandException(this.name + " autochanger must be at HANDOFF or at ONLINE");
            }
            if (!this.autochanger.isAvailable()) {
                throw new RejectedCommandException(this.name + " autochanger must be available");
            }
            if (!this.autochanger.isHoldingFilter()) {
                throw new RejectedCommandException(this.name + " autochanger must hold the filter");
            }
            this.carousel.checkDeltaPosition();
            if (this.autochanger.isAtOnline()) {
                if (this.autochanger.getOnlineClamps().isLocked()) {
                    this.autochanger.getOnlineClamps().unlockClamps();
                }
                if (this.autochanger.getOnlineClamps().isClosed()) {
                    if (this.autochanger.getOnlineClamps().isHomingDone()) {
                        this.autochanger.getOnlineClamps().openClampsNoXBrakes();
                    } else {
                        this.autochanger.getOnlineClamps().homingFusion();
                    }
                }
            }
            this.updateStateWithSensors();
            if (!this.autochanger.getOnlineClamps().isOpened()) {
                throw new FcsHardwareException(this.name + " autochanger online clamps should be opened");
            }
            FCSLOG.info(this.name + " === autochanger is free to move ===");
            FCSLOG.info(this.name + " === carousel is ready to receive a filter at standby ===");
            this.autochanger.moveFilterToStandbyPlusDelta(this.carousel.getSocketAtStandby().getDeltaAutochangerStandbyPosition());
            this.updateStateWithSensors();
            if (this.carousel.isHoldingFilterAtStandby()) {
                FCSLOG.info("=== carousel is CLAMPED_ON_FILTER === ");
                this.carousel.getSocketAtStandby().updateFilterID();
                FCSLOG.info("filter ID on CAROUSEL at STANDBY " + this.carousel.getSocketAtStandby().getFilterID());
                FCSLOG.info("filter ID on autochanger = " + this.autochanger.getFilterID());
                FCSLOG.info("==================================");
            } else {
                this.recoveryLockingProcess();
                if (this.carousel.isHoldingFilterAtStandby()) {
                    this.carousel.getSocketAtStandby().updateFilterID();
                } else {
                    String msg = this.name + ": carousel should be CLAMPED_ON_FILTER when autochanger is at STANDBY with a filter; recovery process didn't work";
                    this.raiseAlarm(FcsEnumerations.FcsAlert.CA_LOCKING_ISSUE, msg, this.name);
                    throw new FcsHardwareException(msg);
                }
            }
            if (!this.autochanger.isAtStandby()) {
                throw new FcsHardwareException(this.name + ": autochanger should be at STANDBY after moveFilterToStandby() command");
            }
            this.autochanger.waitForProtectionSystemUpdate();
            FCSLOG.info(this.name + ": is going to moveEmptyFromStandbyToHandoff");
            this.autochanger.moveEmptyFromStandbyToHandoff(withPrecision);
            this.previousSocketID = -1;
            this.publishDataForMcm();
            this.publishActionDuration(FcsEnumerations.GeneralAction.STORE_FILTER_ON_CAROUSEL, System.currentTimeMillis() - beginTime);
        }
    }

    private void recoveryLockingProcess() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("recoveryLockingProcess");){
            if (this.carousel.getClampXplus().isLocked() && !this.carousel.getClampXminus().isLocked()) {
                FcsUtils.sleep(200, this.name);
                this.carousel.recoveryLockingXminus();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, autoAck=false, description="Unclamp filter from carousel, move autochanger to approachStandby position and release the carousel clamps", timeout=15000)
    public void disengageFilterFromCarousel() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("disengageFilterFromCarousel");){
            long beginTime = System.currentTimeMillis();
            this.movementCounter.get((Object)FcsEnumerations.GeneralAction.DISENGAGE_FILTER_FROM_CAROUSEL).increment();
            this.updateStateWithSensors();
            if (!FcsEnumerations.FilterReadinessState.READY.equals((Object)this.getFilterReadinessState())) {
                throw new RejectedCommandException(this.name + " FilterReadinessState must be READY");
            }
            if (!this.carousel.isAtStandby()) {
                throw new RejectedCommandException(this.name + "Carousel should be at Standby");
            }
            if (!this.autochanger.isAtStandby()) {
                throw new RejectedCommandException("autochanger should be at Standby Position");
            }
            if (!this.autochanger.isAvailable()) {
                throw new RejectedCommandException("autochanger should be available");
            }
            this.carousel.unlockClamps();
            this.carousel.updateStateWithSensors();
            this.carousel.waitForProtectionSystemUpdate();
            if (!this.carousel.isUnclampedOnFilterAtStandby()) {
                String msg = this.name + "Carousel clamps still locked. Aborting autochanger movement because carousel is still holding the filter. bad state for socketAtStandby: " + this.carousel.getClampsStateAtStandby() + " should be UNCLAMPED_ON_FILTER";
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
                throw new FcsHardwareException(this.name + msg);
            }
            this.autochanger.waitForProtectionSystemUpdate();
            this.previousSocketID = this.carousel.getSocketAtStandbyID();
            this.autochanger.getAutochangerTrucks().moveToApproachStandbyPositionWithLowVelocity();
            this.publishDataForMcm();
            this.updateStateWithSensors();
            if (!this.carousel.isEmptyAtStandby()) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Carousel is still seeing the filter", this.name);
                throw new FcsHardwareException(this.name + " aborting autochanger movement because carousel is still seeing filter.");
            }
            FcsUtils.asyncRun(() -> {
                try {
                    this.carousel.releaseClamps();
                }
                catch (Exception e) {
                    this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "cannot release carousel clamps", "carousel");
                }
            });
            this.updateStateWithSensors();
            this.publishActionDuration(FcsEnumerations.GeneralAction.DISENGAGE_FILTER_FROM_CAROUSEL, System.currentTimeMillis() - beginTime);
        }
    }

    public boolean autochangerNotInTravel() {
        return this.autochanger.isAtHandoff() || this.autochanger.isAtOnline() || this.autochanger.isAtStandby();
    }

    public boolean latchesOpenOrClosed() {
        return this.autochanger.getLatches().isClosed() || this.autochanger.getLatches().isOpened();
    }

    public boolean onlineClampsOpenOrLocked() {
        return this.autochanger.getOnlineClamps().isLocked() || this.autochanger.getOnlineClamps().isOpened();
    }

    public boolean filterAtOnlineMustBeLocked() {
        return !this.autochanger.isAtOnline() || this.autochanger.isEmpty() || this.autochanger.getOnlineClamps().isLocked();
    }

    public boolean filterAtStandbyMustBeHeld() {
        return !this.autochanger.isAtStandby() || this.autochanger.isEmpty() || this.autochanger.isHoldingFilter() || this.carousel.isHoldingFilterAtStandby();
    }

    public boolean carouselHoldingFilterOrReadyToGrab() {
        return this.carousel.isHoldingFilterAtStandby() || this.carousel.isReadyToGrabAFilterAtStandby();
    }

    public boolean carouselReadyToClampAtStandby() {
        return this.autochanger.isAtStandby() || this.autochanger.isEmpty() || this.carousel.isReadyToGrabAFilterAtStandby();
    }

    public boolean areTmaAndRotatorLocked() {
        return this.tmaAndRotatorMotionStatus.equals((Object)FcsEnumerations.TelescopeMountRotatorState.LOCKED) || this.tmaAndRotatorMotionStatus.equals((Object)FcsEnumerations.TelescopeMountRotatorState.PROTOTYPE) || this.isLoaderConnected() || FcsUtils.isSimu();
    }

    public boolean trucksMustBeStraight() {
        return this.autochanger.getAutochangerInclinationState().equals((Object)FcsEnumerations.AutochangerInclinationState.STRAIGHT);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", timeout=180000, autoAck=false)
    public void setFilter(int filterID) {
        if (filterID == 0) {
            this.setNoFilterAtHandoffOrOnline(true);
        } else {
            this.setFilterAtHandoffOrOnline(filterID, true, false);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", timeout=180000, autoAck=false)
    public void setFilterByName(String filterName) {
        this.subs.helper().precondition(this.filterManager.containsFilterName(filterName), "%s: Unknown filter name : %s", new Object[]{this.name, filterName}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).action(() -> this.setFilter(this.filterManager.getFilterID(filterName)));
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Select filter and move to HANDOFF position without going to ONLINE.", timeout=180000, autoAck=false)
    public void setFilterAtHandoff(int filterID) {
        if (filterID == 0) {
            this.setNoFilterAtHandoffOrOnline(false);
        } else {
            this.setFilterAtHandoffOrOnline(filterID, false, false);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Select filter and move to HANDOFF position without going to ONLINE.", timeout=180000, autoAck=false)
    public void setFilterAtHandoffForLoader(int filterID) {
        this.setFilterAtHandoffOrOnline(filterID, false, true);
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, level=0, description="Store all filters on carousel and move autochanger trucks to ONLINE.", timeout=180000, autoAck=false)
    public void setNoFilter() {
        this.setNoFilterAtHandoffOrOnline(true);
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, level=0, description="Store all filters on carousel and move autochanger trucks to HANDOFF.", timeout=180000, autoAck=false)
    public void setNoFilterAtHandoff() {
        this.setNoFilterAtHandoffOrOnline(false);
    }

    private void setFilterAtHandoffOrOnline(int filterID, boolean toOnline, boolean forLoader) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("setFilter");){
            this.updateStateWithSensors();
            if (this.carousel.isPowerSaveActivated()) {
                this.carousel.powerOn(this.carouselWakeUpDuration);
                this.autochanger.waitForProtectionSystemUpdate();
            }
            this.percentage = 0;
            this.publishDataForMcm();
            this.checkControllers();
            FCSLOG.info(this.name + ": filter to set online:" + filterID);
            this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Supplier[0]).precondition(this.areTmaAndRotatorLocked(), "The telescope motion and rotator need to be locked before performing a filter exchange. Current status of the lock is %s", new Object[]{this.getTelescopeSoftwareLockStatus()}).precondition(this.trucksMustBeStraight(), "The FCS does not allow a filter exchange to be executed because the autochanger/camera is currently tilted. Ensure the rotator is set back to 0 before trying again.", new Supplier[0]).precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(this.isFilterInCamera(filterID), "%s: filter %s / filter name %s is out of camera", new Object[]{this.name, filterID, this.filterManager.getFilterNameByID(filterID)}).precondition(this.isFilterAvailable(filterID), "%s: filter %s / filter name %s is not available", new Object[]{this.name, filterID, this.filterManager.getFilterNameByID(filterID)}).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Supplier[0]).precondition(this.autochangerNotInTravel(), "autochanger trucks are not at a HANDOFF or ONLINE or STANDBY", new Supplier[0]).precondition(this.autochanger.isAvailable(), "autochanger is not available", new Supplier[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for autochanger ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for autochanger ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by autochanger or by carousel.", new Supplier[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on autochanger at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).duration(SETFILTER_MAX_DURATION).enterFaultOnException(true).action(() -> {
                FcsEnumerations.GeneralAction action = forLoader ? FcsEnumerations.GeneralAction.SET_FILTER_AT_HANDOFF_FOR_LOADER : FcsEnumerations.GeneralAction.SET_FILTER;
                this.movementCounter.get((Object)action).increment();
                long beginTime = System.currentTimeMillis();
                if (this.autochanger.isHoldingFilter()) {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.LOADED});
                    FCSLOG.info(this.name + ": autochanger is holding a filter, filter name= " + this.autochanger.getFilterOnTrucksName());
                } else {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.NOFILTER});
                    FCSLOG.info(this.name + ": autochanger is not holding filter, filter name on autochanger" + this.autochanger.getFilterOnTrucksName());
                    FCSLOG.info(this.name + ": filterID: " + filterID + " is on socket:" + this.carousel.getFilterSocket(filterID).getId());
                }
                this.carousel.setControllerPositionSensorTypeEncoderSSI();
                if (!this.autochanger.isFilterOnAC(filterID)) {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.UNLOADING});
                    FCSLOG.info(this.name + ": filterID: " + filterID + " is NOT on autochanger");
                    if (this.autochanger.isAtStandby()) {
                        FCSLOG.info(this.name + " autochanger is at STANDBY, it has to be moved empty at HANDOFF");
                        this.autochanger.moveEmptyFromStandbyToHandoff();
                    } else if (this.autochanger.isHoldingFilter()) {
                        FCSLOG.info(this.name + ": autochanger is holding filter: " + this.autochanger.getFilterOnTrucksName());
                        FCSLOG.info(this.name + ": is going to store a filter on carousel");
                        this.storeFilterOnCarouselRelaxed();
                    }
                    this.percentage = 20;
                    this.publishDataForMcm();
                    if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                        throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff or online");
                    }
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.ROTATING});
                    this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
                    FcsUtils.sleep(100, this.name);
                    this.percentage = 40;
                    this.publishDataForMcm();
                    this.updateStateWithSensors();
                    if (!this.carousel.isAtStandby()) {
                        throw new FcsHardwareException(this.name + ": carousel should be at standby after rotateSocketToStandby command.");
                    }
                    FCSLOG.info(this.name + ": carousel is at standby");
                    if (this.carousel.getFilterIDatStandby() != filterID) {
                        throw new FcsHardwareException(this.name + " filterID at standby is " + this.carousel.getFilterIDatStandby() + " should be: " + filterID);
                    }
                    this.carousel.checkDeltaPosition();
                    this.autochanger.waitForProtectionSystemUpdate();
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.LOADING});
                    this.autochanger.grabFilterAtStandby();
                    this.updateStateWithSensors();
                    this.percentage = 60;
                    this.previousSocketID = this.carousel.getSocketAtStandbyID();
                    this.publishDataForMcm();
                    this.updateStateWithSensors();
                    if (!this.autochanger.isFilterOnAC(filterID)) {
                        throw new FcsHardwareException(this.name + " filter: " + filterID + " should be now on autochanger");
                    }
                }
                if (this.autochanger.isAtStandby()) {
                    g = new AutochangerTwoTrucks.ReleasedACBrakes(this.autochanger.getAutochangerTrucks());
                    try {
                        this.disengageFilterFromCarousel();
                        this.percentage = 80;
                        this.publishDataForMcm();
                        this.updateStateWithSensors();
                        if (toOnline) {
                            this.autochanger.moveAndClampFilterOnline();
                        }
                        this.moveToHandoffWithHighVelocity(forLoader);
                    }
                    finally {
                        g.close();
                    }
                } else if (toOnline) {
                    if (this.autochanger.isAtHandoff()) {
                        this.autochanger.moveAndClampFilterOnline();
                    } else if (this.autochanger.isAtOnline()) {
                        this.autochanger.lockFilterAtOnline();
                    }
                } else if (this.autochanger.isAtOnline() && this.autochanger.getOnlineClamps().isOpened()) {
                    g = new AutochangerTwoTrucks.ReleasedACBrakes(this.autochanger.getAutochangerTrucks());
                    try {
                        this.autochanger.getAutochangerTrucks().moveToApproachOnlinePositionWithLowVelocity();
                        this.moveToHandoffWithHighVelocity(forLoader);
                    }
                    finally {
                        g.close();
                    }
                }
                String filterName = this.filterManager.getFilterNameByID(filterID);
                this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + filterName.toUpperCase()));
                this.publishData();
                this.publishActionDuration(action, System.currentTimeMillis() - beginTime);
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.LOADED});
                this.percentage = 100;
                this.publishDataForMcm();
                if (toOnline && this.carousel.isPowerSaveAllowed()) {
                    this.carousel.powerSave();
                }
                this.percentage = 0;
            });
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set filter online but do not close the clamps. This is used for Winter 2023/2024 focal plane tests to avoid activating the autochanger online clamps.", timeout=180000, autoAck=false)
    public void setFilterNoClamping(int filterID) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("setFilterNoClamping");){
            this.updateStateWithSensors();
            this.publishDataForMcm();
            this.checkControllers();
            FCSLOG.info(this.name + ": filter to set online without clamping:" + filterID);
            this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Supplier[0]).precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(this.isFilterInCamera(filterID), "%s: filter %s / filter name %s is out of camera", new Object[]{this.name, filterID, this.filterManager.getFilterNameByID(filterID)}).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Supplier[0]).precondition(this.autochangerNotInTravel(), "AC trucks are not at a HANDOFF or ONLINE or STANDBY", new Supplier[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for AC ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for AC ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by AC or by carousel.", new Supplier[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on AC at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).duration(SETFILTER_MAX_DURATION).enterFaultOnException(true).action(() -> {
                this.movementCounter.get((Object)FcsEnumerations.GeneralAction.SET_FILTER).increment();
                long beginTime = System.currentTimeMillis();
                if (this.autochanger.isHoldingFilter()) {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.LOADED});
                    FCSLOG.info(this.name + ": AC is holding a filter, filter name= " + this.autochanger.getFilterOnTrucksName());
                } else {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.NOFILTER});
                    FCSLOG.info(this.name + ": AC is not holding filter, filter name on AC" + this.autochanger.getFilterOnTrucksName());
                    FCSLOG.info(this.name + ": filterID: " + filterID + " is on socket:" + this.carousel.getFilterSocket(filterID).getId());
                }
                this.carousel.setControllerPositionSensorTypeEncoderSSI();
                if (!this.autochanger.isFilterOnAC(filterID)) {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.UNLOADING});
                    FCSLOG.info(this.name + ": filterID: " + filterID + " is NOT on AC");
                    if (this.autochanger.isAtStandby()) {
                        FCSLOG.info(this.name + " autochanger is at STANDBY, it has to be moved empty at HANDOFF");
                        this.autochanger.moveEmptyFromStandbyToHandoff();
                    } else if (this.autochanger.isHoldingFilter()) {
                        FCSLOG.info(this.name + ": AC is holding filter: " + this.autochanger.getFilterOnTrucksName());
                        FCSLOG.info(this.name + ": is going to store a filter on carousel");
                        this.storeFilterOnCarouselRelaxed();
                    }
                    if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                        throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff or online");
                    }
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.ROTATING});
                    this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
                    FcsUtils.sleep(100, this.name);
                    this.updateStateWithSensors();
                    if (!this.carousel.isAtStandby()) {
                        throw new FcsHardwareException(this.name + ": carousel should be at standby after rotateSocketToStandby command.");
                    }
                    FCSLOG.info(this.name + ": carousel is at standby");
                    if (this.carousel.getFilterIDatStandby() != filterID) {
                        throw new FcsHardwareException(this.name + " filterID at standby is " + this.carousel.getFilterIDatStandby() + " should be: " + filterID);
                    }
                    this.carousel.checkDeltaPosition();
                    this.autochanger.waitForProtectionSystemUpdate();
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.LOADING});
                    this.autochanger.grabFilterAtStandby();
                    this.updateStateWithSensors();
                    if (!this.autochanger.isFilterOnAC(filterID)) {
                        throw new FcsHardwareException(this.name + " filter: " + filterID + " should be now on AC");
                    }
                }
                if (!this.autochanger.isAtOnline()) {
                    if (this.autochanger.isAtStandby()) {
                        try (AutochangerTwoTrucks.ReleasedACBrakes g = new AutochangerTwoTrucks.ReleasedACBrakes(this.autochanger.getAutochangerTrucks());){
                            this.disengageFilterFromCarousel();
                            this.updateStateWithSensors();
                            this.autochanger.moveFilterOnlineNoClamping();
                        }
                    } else if (this.autochanger.isAtHandoff()) {
                        this.autochanger.moveFilterOnlineNoClamping();
                    }
                }
                String filterName = this.filterManager.getFilterNameByID(filterID);
                this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + filterName.toUpperCase()));
                this.publishData();
                this.publishActionDuration(FcsEnumerations.GeneralAction.SET_FILTER, System.currentTimeMillis() - beginTime);
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.LOADED});
                this.publishDataForMcm();
            });
        }
    }

    private void moveToHandoffWithHighVelocity(boolean forLoader) {
        if (forLoader) {
            this.autochanger.getAutochangerTrucks().fastProfile();
            this.autochanger.getAutochangerTrucks().goToHandOffForLoader();
        } else {
            this.autochanger.getAutochangerTrucks().moveToHandoffWithHighVelocity();
        }
    }

    private void setNoFilterAtHandoffOrOnline(boolean toOnline) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("setNoFilter");){
            this.updateStateWithSensors();
            if (this.carousel.isPowerSaveActivated()) {
                this.carousel.powerOn(this.carouselWakeUpDuration);
            }
            this.publishDataForMcm();
            this.checkControllers();
            this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Supplier[0]).precondition(this.areTmaAndRotatorLocked(), "The telescope motion and rotator need to be locked before performing a filter exchange. Current status of the lock is %s", new Object[]{this.getTelescopeSoftwareLockStatus()}).precondition(this.trucksMustBeStraight(), "The FCS does not allow a filter exchange to be executed because the autochanger/camera is currently tilted. Ensure the rotator is set back to 0 before trying again.", new Supplier[0]).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Supplier[0]).precondition(this.autochangerNotInTravel(), "autochanger trucks are not at a HANDOFF or ONLINE or STANDBY", new Supplier[0]).precondition(this.autochanger.isAvailable(), "autochanger is not available", new Supplier[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for autochanger ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for autochanger ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by autochanger or by carousel.", new Supplier[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on autochanger at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).duration(SETFILTER_MAX_DURATION).enterFaultOnException(true).action(() -> {
                this.movementCounter.get((Object)FcsEnumerations.GeneralAction.SET_NO_FILTER).increment();
                long beginTime = System.currentTimeMillis();
                if (this.autochanger.isHoldingFilter()) {
                    FCSLOG.info(this.name + ": autochanger is holding filter: " + this.autochanger.getFilterOnTrucksName());
                    FCSLOG.info(this.name + ": is going to store a filter on carousel");
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.McmFilterState.UNLOADING});
                    this.storeFilterOnCarousel();
                } else {
                    FCSLOG.info(this.name + " no filter to store on carousel");
                }
                if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                    throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff");
                }
                if (toOnline) {
                    this.autochanger.goToOnline();
                }
                this.updateAgentState(FcsEnumerations.FilterState.ONLINE_NONE);
                this.updateAgentState(FcsEnumerations.McmFilterState.NOFILTER);
                if (this.carousel.isPowerSaveAllowed()) {
                    this.carousel.powerSave();
                }
                this.publishDataForMcm();
                this.publishData();
                this.publishActionDuration(FcsEnumerations.GeneralAction.SET_NO_FILTER, System.currentTimeMillis() - beginTime);
            });
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="change subsystem state.")
    public void changeState(String state) {
        this.updateAgentState(FcsEnumerations.FilterState.valueOf(state));
        FCSLOG.fine(() -> "SUBSYSTEM STATE=" + this.isInState(FcsEnumerations.FilterState.valueOf(state)));
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=0, description="list filters in Filter Changer.")
    public Map<Integer, String> listFiltersOnChanger() {
        HashMap<Integer, String> lf = new HashMap<Integer, String>();
        if (this.autochanger.getFilterID() != 0) {
            lf.put(this.autochanger.getFilterID(), this.autochanger.getFilterOnTrucksName());
        }
        this.carousel.getSocketsMap().values().stream().forEach(socket -> {
            if (!socket.isEmpty()) {
                lf.put(socket.getFilterID(), socket.getFilterName());
            }
        });
        return lf;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=0, description="list filters in Filter Changer.")
    public List<String> listAllFilters() {
        return this.listAllFilterNames();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List the possible filters names as defined in the filter manager.")
    public List<String> listAllFilterNames() {
        return this.filterManager.getFilterNames();
    }

    public Map<String, Filter> getFcsFilterMap() {
        TreeMap<String, Filter> lf = new TreeMap<String, Filter>();
        if (this.autochanger.getFilterID() != 0) {
            lf.put("autochanger", this.filterManager.getFilterByID(this.autochanger.getFilterID()));
        }
        this.carousel.getSocketsMap().values().stream().forEach(socket -> {
            if (!socket.isEmpty() && socket.getFilterID() != 0) {
                lf.put(socket.getName(), this.filterManager.getFilterByID(socket.getFilterID()));
            }
        });
        return lf;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Print information on the filters physically in the LSSTCam.")
    public String printFilterMap() {
        StringBuilder sb = new StringBuilder("Filters on FES: \n");
        this.getFcsFilterMap().entrySet().stream().forEach(e -> {
            String socketName = (String)e.getKey();
            if (socketName != "autochanger" && !this.carousel.getSocketByName(socketName).isAvailable()) {
                sb.append("* ");
            }
            sb.append(socketName);
            sb.append("\n\t");
            sb.append(((Filter)e.getValue()).toString());
            sb.append("\n");
        });
        sb.append("\n'*' marks the currently unavailable sockets with filters.\n");
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Print general information on a filter.")
    public String printFilterInfo(String filterName) {
        return this.filterManager.getFilterByName(filterName).toString();
    }

    public Map<Integer, String> getAvailableFilterMap() {
        TreeMap<Integer, String> availableFilterMap = new TreeMap<Integer, String>();
        if (!this.autochanger.isAvailable()) {
            if (this.autochanger.isAtOnline()) {
                availableFilterMap.put(this.autochanger.getFilterID(), this.autochanger.getFilterOnTrucksName());
            }
            return availableFilterMap;
        }
        if (!this.carousel.isAvailable()) {
            if (!this.carousel.socketAtStandby.isEmpty()) {
                if (this.carousel.socketAtStandby.isAvailable()) {
                    availableFilterMap.put(this.carousel.socketAtStandby.getFilterID(), this.carousel.socketAtStandby.getFilterName());
                }
                availableFilterMap.put(0, "NONE");
            } else if (!this.autochanger.isEmpty()) {
                availableFilterMap.put(this.autochanger.getFilterID(), this.autochanger.getFilterOnTrucksName());
                if (this.carousel.socketAtStandby.isAvailable()) {
                    availableFilterMap.put(0, "NONE");
                }
            }
            return availableFilterMap;
        }
        if (!this.autochanger.isEmpty() && !this.autochanger.isAtStandby()) {
            availableFilterMap.put(this.autochanger.getFilterID(), this.autochanger.getFilterOnTrucksName());
            if (!this.carousel.socketsMap.values().stream().anyMatch(socket -> socket.isEmpty() && socket.isAvailable())) {
                return availableFilterMap;
            }
        }
        this.carousel.getSocketsMap().values().stream().forEach(socket -> {
            if (!socket.isEmpty() && socket.getFilterID() != 0 && socket.isAvailable()) {
                Filter f = this.filterManager.getFilterByID(socket.getFilterID());
                availableFilterMap.put(f.getFilterID(), f.getName());
            }
        });
        availableFilterMap.put(0, "NONE");
        return availableFilterMap;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the list of available filters ID in the Filter Exchange System")
    public List<Integer> getAvailableFiltersID() {
        return this.getAvailableFilterMap().keySet().stream().filter(filterID -> filterID != 0).toList();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide a mapping carousel sockets to available filters ID in the Filter Exchange System")
    public Map<String, Integer> getSocketsToAvailableFiltersID() {
        List<Integer> availableFiltersID = this.getAvailableFiltersID();
        TreeMap<String, Integer> fm = new TreeMap<String, Integer>();
        this.carousel.getSocketsMap().values().stream().forEach(socket -> {
            if (socket.isEmpty()) {
                if (socket.isAtStandby() && availableFiltersID.contains(this.autochanger.getFilterID())) {
                    fm.put(socket.getName(), this.autochanger.getFilterID());
                }
            } else if (availableFiltersID.contains(socket.getFilterID())) {
                fm.put(socket.getName(), socket.getFilterID());
            }
        });
        return fm;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the list of available filters in the Filter Exchange System formatted as wanted by the OCS Bridge")
    public List<String> getAvailableFilters() {
        return this.getAvailableFilterMap().keySet().stream().map(filterID -> this.filterManager.getObservatoryNameByID((int)filterID)).collect(Collectors.toList());
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the list of installed filters in the Filter Exchange System formatted as wanted by the OCS Bridge.")
    public List<String> getInstalledFilters() {
        return this.getFcsFilterMap().entrySet().stream().map(entry -> ((Filter)entry.getValue()).getObservatoryName()).collect(Collectors.toList());
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the name of the filter currently online, formatted as wanted by the OCS Bridge")
    public String getOnlineFilterName() {
        int filterId = 0;
        if (this.autochanger.isAtOnline()) {
            filterId = this.autochanger.getFilterID();
        }
        return this.filterManager.getObservatoryNameByID(filterId);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the maximum angle from vertical at which a filter exchange can be executed as wanted by the OCS Bridge.")
    public double getMaxAngleForFilterChange() {
        return 90.0;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the maximum angle from vertical at which a filter exchange can be executed in normal speed (fast) as wanted by the OCS Bridge.")
    public double getMaxAngleForFastFilterChange() {
        int airmass = 3;
        return Math.acos(1.0 / (double)airmass) * 180.0 / Math.PI;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the maximum duration of a filter exchange in slow-mode conditions as wanted by the OCS Bridge.")
    public Duration getDurationForSlowFilterChange(String filterName) {
        return Duration.ofSeconds(this.setFilterSlowDuration);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Provide the maximum duration of a filter exchange in normal conditions as wanted by the OCS Bridge.")
    public Duration getDurationForFastFilterChange(String filterName) {
        return Duration.ofSeconds(this.setFilterFastDuration);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Control the power state of the filter changer carousel. Options are 0: go to sleep, 1: wake up and go back to sleep after setFilter, 2: wake up and stay up")
    public void wakeFilterChanger(int mode) {
        try {
            FcsEnumerations.CarouselPowerMode wakeUpMode = FcsEnumerations.CarouselPowerMode.values()[mode];
            FCSLOG.info("wakeFilterChanger was issued with mode : " + wakeUpMode);
            this.wakeFilterChanger(wakeUpMode);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RejectedCommandException("The only available modes for wakeFilterChanger are 0: go to sleep, 1: wake up, 2: wake up and stay up");
        }
    }

    private void wakeFilterChanger(FcsEnumerations.CarouselPowerMode mode) {
        switch (mode) {
            case GO_TO_SLEEP: {
                if (this.agentStateService.isInState((Enum)FcsEnumerations.CarouselPowerState.REGULAR)) {
                    this.carousel.powerSave();
                    break;
                }
                FCSLOG.info("filter changer already in power save");
                break;
            }
            case WAKE_UP: {
                this.carousel.setPowerSaveAllowed(true);
                if (this.agentStateService.isInState((Enum)FcsEnumerations.CarouselPowerState.LOW_POWER)) {
                    this.carousel.powerOn(this.carouselWakeUpDuration);
                    break;
                }
                FCSLOG.info("filter changer already waken up, switching power save allowed to true");
                break;
            }
            case STAY_UP: {
                this.carousel.setPowerSaveAllowed(false);
                if (this.agentStateService.isInState((Enum)FcsEnumerations.CarouselPowerState.LOW_POWER)) {
                    this.carousel.powerOn(this.carouselWakeUpDuration);
                    break;
                }
                FCSLOG.info("filter changer already waken up, switching power save allowed to false");
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="")
    public Duration getDurationForWakeUp(int mode) {
        return Duration.ofSeconds(this.carouselWakeUpDuration);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Load a filter from the loader to the camera. The loader must hold a filter at STORAGE position.The autochanger must be empty at HANDOFF, latches open. At the end of this command thefilter is held by autochanger at Handoff position, and the loader carrier is empty at STORAGE.", timeout=480000, autoAck=false)
    public void loadFilter() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("loadFilter");){
            this.updateStateWithSensors();
            this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Supplier[0]).precondition(this.autochanger.isAtHandoff() && this.autochanger.isEmpty(), " autochanger is not empty at HANDOFF position; can't load a filter.", new Supplier[0]).precondition(this.autochanger.getLatches().isOpened(), "Autochanger latches must be open before loadFilter command.", new Supplier[0]).duration(LOAD_UNLOAD_FILTER_MAX_DURATION).enterFaultOnException(true).action(() -> {
                this.movementCounter.get((Object)FcsEnumerations.GeneralAction.LOAD_FILTER).increment();
                long beginTime = System.currentTimeMillis();
                if (!this.autochanger.isPositionCorrectForExchangeWithLoader()) {
                    FCSLOG.info(this.name + " autochanger not in correct position for exchange with loader, trying to align the trucks");
                    this.autochanger.goToHandOffForLoader();
                }
                if (this.loader.getCarrier().isLooslyBetweenStorageAndEngaged() && !this.loader.isClampedOnFilter()) {
                    FCSLOG.info(this.name + " loader between STORAGE and ENGAGED with hooks not CLAMPED. Starting recovery to get back to a CLAMPED state to continue the load operation. ");
                    this.loader.getClamp().recoveryUnclamp();
                    FcsUtils.sleep(50, this.name);
                    this.updateStateWithSensors();
                    this.loader.getClamp().recoveryClamp();
                    FcsUtils.sleep(50, this.name);
                    this.updateStateWithSensors();
                }
                this.loader.moveFilterToHandoff();
                FcsUtils.sleep(50, this.name);
                this.updateStateWithSensors();
                this.autochanger.closeLatches();
                FcsUtils.sleep(50, this.name);
                this.updateStateWithSensors();
                this.loader.openClampAndMoveEmptyToStorage();
                FcsUtils.sleep(50, this.name);
                this.updateStateWithSensors();
                this.publishActionDuration(FcsEnumerations.GeneralAction.LOAD_FILTER, System.currentTimeMillis() - beginTime);
            });
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Load a filter from the loader to the cameraand store it on socket which name is given as argument. The loader must hold a filter at STORAGE position.The autochanger must be empty at HANDOFF, latches open. At the end of this command thefilter is store on carousel socket which name is given as argument, autochanger is empty at Handoff position, and the loader carrier is empty at STORAGE.")
    public void loadFilterOnSocket(String socketName) {
        this.updateStateWithSensors();
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socket = this.carousel.getSocketsMap().get(socketName);
        if (!socket.isEmpty()) {
            throw new RejectedCommandException(String.format("Can't execute loadFilterOnSocket because %s is not empty. Select an empty socket.", socketName));
        }
        if (!socket.isAvailable()) {
            throw new RejectedCommandException(String.format("Can't execute loadFilterOnSocket because %s is not available. Select an available socket.", socketName));
        }
        this.loadFilter();
        this.carousel.rotateSocketToStandby(socketName);
        this.storeFilterOnCarousel();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unload a filter from the camera to the loader. The camera has to be at horizontal position. The filter has to be on Autochanger at HANDOFF. Loader carrier must be empty at STORAGE. \nAt the end of this command, autochanger is empty at HANDOFF, latches are open, and loader carrier is holding the filter at STORAGE (hooks are clamped)", timeout=480000, autoAck=false)
    public void unloadFilter() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("unloadFilter");){
            this.updateStateWithSensors();
            this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Supplier[0]).precondition(this.autochanger.isAtHandoff() && this.autochanger.isHoldingFilter(), " autochanger is not holding a filter at HANDOFF position; can't unload a filter.", new Supplier[0]).precondition(this.autochanger.isAvailable(), "autochanger is not available", new Supplier[0]).duration(LOAD_UNLOAD_FILTER_MAX_DURATION).enterFaultOnException(true).action(() -> {
                this.movementCounter.get((Object)FcsEnumerations.GeneralAction.UNLOAD_FILTER).increment();
                long beginTime = System.currentTimeMillis();
                if (!this.autochanger.isPositionCorrectForExchangeWithLoader()) {
                    if (this.autochanger.isLinearRailMotionAllowed()) {
                        this.autochanger.goToHandOffForLoader();
                    } else {
                        throw new RejectedCommandException("Autochanger trucks position is not correct for exchange with loader  but command goToHandOffForLoader can't be executed because PLC doesn't allow to move trucks.");
                    }
                }
                this.loader.moveEmptyToHandoffAndClose();
                FcsUtils.sleep(50, this.name);
                this.updateStateWithSensors();
                this.autochanger.openLatches();
                FcsUtils.sleep(50, this.name);
                this.updateStateWithSensors();
                this.loader.moveFilterToStorage();
                FcsUtils.sleep(50, this.name);
                this.updateStateWithSensors();
                this.publishActionDuration(FcsEnumerations.GeneralAction.UNLOAD_FILTER, System.currentTimeMillis() - beginTime);
            });
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Recover from a timeout or an exception raised during the carousel clamping process. This command moves the filter back to handoff position and releases both carousel clamps.")
    public void recoveryCarouselClamping() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("recoveryCarouselClamping");){
            this.carousel.unlockClamps();
            this.autochanger.moveToApproachStandbyPositionWithLowVelocity();
            this.carousel.releaseClamps();
            this.autochanger.moveToHandoffWithHighVelocity();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="check if controllers are in fault")
    public void checkControllers() {
        this.bridge.checkControllers();
    }

    @Override
    public synchronized void updateStateWithSensors() {
        long beginTime = System.currentTimeMillis();
        if (!FcsUtils.isSimu() && beginTime - this.lastUpdateStateWithSensors.get() < 100L) {
            FCSLOG.info(this.name + " do not repeat updateStateWithSensors; last one was executed less than 100ms ago.");
            return;
        }
        this.lastUpdateStateWithSensors.set(beginTime);
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateStateWithSensors-fcs");){
            this.carousel.updateStateWithSensors();
            if (this.carousel.isAtStandby()) {
                this.carousel.getSocketAtStandby().updateFilterID();
            }
            this.autochanger.updateStateWithSensors();
            if (this.autochanger.getAutochangerTrucks().isAtOnline() && this.autochanger.isHoldingFilter() && this.autochanger.getOnlineClamps().isLocked()) {
                String filterName = this.filterManager.getFilterNameByID(this.autochanger.getFilterID());
                this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + filterName.toUpperCase()));
            } else {
                this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_NONE"));
            }
            if (this.loader.isCANbusConnected()) {
                this.loader.updateStateWithSensors();
            }
        }
        if (this.firstMCMpublication) {
            this.publishDataForMcm();
            this.firstMCMpublication = false;
        }
    }

    @Override
    public void initializeHardware() {
        this.carousel.initializeHardware();
        this.autochanger.initializeHardware();
        this.loader.initializeHardware();
        this.postStart();
        FCSLOG.info("initializeHardware done");
    }

    @Override
    public void publishData() {
        super.publishData();
        this.bridgeToLoader.publishData();
    }

    public void publishDataForMcm() {
        if (this.autochanger.getAutochangerTrucks().getPosition() == 0) {
            FcsUtils.sleep(100, "main");
            this.autochanger.updateStateWithSensors();
        }
        this.updateAgentState(this.autochanger.getAutochangerInclinationState());
        this.subs.publishSubsystemDataOnStatusBus(this.getDataForMcm());
    }

    public void publishDataProviderCurrentData(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!AgentInfo.AgentType.MCM.equals((Object)agent.getType())) continue;
            FCSLOG.info("FCS published for MCM that just joined the buses.");
            this.publishDataForMcm();
            break;
        }
    }

    public void publishActionDuration(FcsEnumerations.GeneralAction action, long duration) {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.getDurationPath(action.name()), (Serializable)Long.valueOf(duration)));
    }

    private KeyValueData getDataForMcm() {
        KeyValueDataList kvdl = new KeyValueDataList();
        kvdl.addData("filter_on_autochanger", (Serializable)((Object)this.filterManager.getObservatoryNameByID(this.autochanger.getFilterID())));
        kvdl.addData("filter_previous_socketID", (Serializable)Integer.valueOf(this.previousSocketID));
        kvdl.addData("autochanger_trucks_position", (Serializable)Integer.valueOf(this.autochanger.getAutochangerTrucks().getPosition()));
        kvdl.addData("autochanger_trucks_state", (Serializable)((Object)this.autochanger.getAutochangerTrucksState()));
        kvdl.addData("setFilter_percentage", (Serializable)Integer.valueOf(this.percentage));
        kvdl.addData("proximity", (Serializable)Integer.valueOf(this.autochanger.getOnlineProximityDistance()));
        return new KeyValueData(PUBLICATION_KEY_FOR_MCM, (Serializable)kvdl);
    }

    @Override
    public void postShutdown() {
        FCSLOG.info(this.name + " is shutting down.");
        this.bridge.doShutdown();
        if (this.loader.isCANbusConnected()) {
            this.bridgeToLoader.doShutdown();
        }
        FCSLOG.info(this.name + " is shutdown.");
    }

    public String vetoTransitionToNormalMode() {
        if (this.isChangerReady()) {
            this.publishDataForMcm();
            if (this.autochanger.isHoldingFilter() && this.autochanger.isAtOnline()) {
                this.updateAgentState(FcsEnumerations.McmFilterState.LOADED);
            } else {
                this.updateAgentState(FcsEnumerations.McmFilterState.NOFILTER);
            }
            return super.vetoTransitionToNormalMode();
        }
        return "FilterChanger not ready";
    }
}

