###########################################################################
#Script to test the simulated hardware of carousel in standalone mode.
#This test is a part of integration tests.
###########################################################################
#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException
import java.time

 
timeoutFiveMillis = java.time.Duration.ofMillis(5)
timeoutThreeSec = java.time.Duration.ofSeconds(3)

print "Loading module", __name__

#
CCS.setThrowExceptions(True)

subsName = "carousel-standalone-simu"
carouselStandalone = CCS.attachSubsystem(subsName);
print "Connected to carousel in STANDALONE mode.", carouselStandalone

###Filters###
filterMng = CCS.attachSubsystem(subsName + "/filterManager")
result = filterMng.sendSynchCommand(timeoutFiveMillis, "toString")
print "### Filter Manager:", result.getResult()
print "### end Filter Manager"
###end Filters###

#getting timeouts
carouselConfigFuture = carouselStandalone.sendAsynchCommand("getConfigurationInfo")
print "getting carousel subsystem configuration"
carouselConfig = carouselConfigFuture.get()

print "Carousel config =", carouselConfig.toString()

CCS.setThrowExceptions(False)

#Handle the thrown exceptions                                                                                                 
print "read sensors and update state "
result = carouselStandalone.sendSynchCommand(timeoutThreeSec, "updateStateWithSensors")

if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())

#print "Carousel Subsystem state has been updated"
CCS.setThrowExceptions(True)

########################################################

