
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;

/**
 * In the autochanger-standalone subsystem, there are 2 electric switches to simulate that
 * carousel is holding a filter at STANDBY or loader is holding a filter at HANDOFF.
 *
 * This switches are connected to sensors which sends value 0 when not holding filter or 1 when holding filter.
 *
 * For FCS with real hardware this sensors are read like the other sensors from the plutoGateway.
 * For FCS with simulated hardware we have to add these sensors in plutoGateway to be able to simulate
 * fuunctionalities of the switches (isHolding filter or not).
 *
 * @author virieux
 */
public class SimuAutochangerStandalonePlutoGateway extends SimuAutochangerPlutoGateway {

    private DigitalSensor carouselHoldingFilterSensor0;
    private DigitalSensor carouselHoldingFilterSensor1;

    private DigitalSensor loaderHoldingFilterSensor0;
    private DigitalSensor loaderHoldingFilterSensor1;

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = subs.getComponentLookup();
        this.carouselHoldingFilterSensor0 = (DigitalSensor)lookup.getComponentByPath("carouselHoldingFilterSensor0");
        this.carouselHoldingFilterSensor1 = (DigitalSensor)lookup.getComponentByPath("carouselHoldingFilterSensor1");
        this.loaderHoldingFilterSensor0 = (DigitalSensor)lookup.getComponentByPath("loaderHoldingFilterSensor0");
        this.loaderHoldingFilterSensor1 = (DigitalSensor)lookup.getComponentByPath("loaderHoldingFilterSensor1");
    }


    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING_ROUTINE)
    public void simulateCarouselIsHoldingFilter() {
        replaceSensorValue(carouselHoldingFilterSensor0, true);
        replaceSensorValue(carouselHoldingFilterSensor1, false);
        /* carousel and loader can't both hold filter*/
        simulateLoaderIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING_ROUTINE)
    public void simulateCarouselIsNotHoldingFilter() {
        replaceSensorValue(carouselHoldingFilterSensor0, false);
        replaceSensorValue(carouselHoldingFilterSensor1, true);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING_ROUTINE)
    public void simulateLoaderIsHoldingFilter() {
        this.simulateLoaderIsConnected();
        replaceSensorValue(loaderHoldingFilterSensor0, true);
        replaceSensorValue(loaderHoldingFilterSensor1, false);
        /* carousel and loader can't both hold filter*/
        simulateCarouselIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING_ROUTINE)
    public void simulateLoaderIsNotHoldingFilter() {
        replaceSensorValue(loaderHoldingFilterSensor0, false);
        replaceSensorValue(loaderHoldingFilterSensor1, true);
    }

    public void postStart() {
        simulateCarouselIsNotHoldingFilter();
        simulateLoaderIsNotHoldingFilter();
    }

}
