/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.Properties;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.camera.sal.classes.DataProviderInfoUtils;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryService;

public final class DescriptionsAndUnitsCheckerService
implements ServiceLifecycle,
AgentService {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataDictionaryService;

    public String getAgentServiceName() {
        return "descritionsAndUnitsCheckerService";
    }

    public boolean startForAgent(AgentInfo agentInfo) {
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        return MakeXMLConfiguration.hasDictionaryConfiguration(agentInfo) && props.getProperty("org.lsst.ccs.datadictionary.require.units.and.descriptions", "true").toLowerCase().equals("true");
    }

    public void preStart() {
        StringBuilder unitsSb = new StringBuilder();
        StringBuilder descriptionSb = new StringBuilder();
        for (DataProviderInfo info : this.dataDictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            String description;
            String dataTypeAttr;
            if (!DataProviderInfoUtils.acceptDataProviderInfo(info) || (dataTypeAttr = info.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE)) == null || !dataTypeAttr.equals(DataProviderInfo.Type.CONFIGURATION.name()) && !dataTypeAttr.equals(DataProviderInfo.Type.MONITORING.name()) && !dataTypeAttr.equals(DataProviderInfo.Type.TRENDING.name())) continue;
            String units = info.getAttributeValue(DataProviderInfo.Attribute.UNITS);
            if (units == null || units.isEmpty()) {
                unitsSb.append(info.getFullPath()).append("\n");
            }
            if ((description = info.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION)) != null && !description.isEmpty()) continue;
            descriptionSb.append(info.getFullPath()).append("\n");
        }
        StringBuilder missingUnitsDescriptions = new StringBuilder();
        if (!unitsSb.toString().isEmpty()) {
            missingUnitsDescriptions.append("Missing Units for the follwing paths: \n").append(unitsSb.toString()).append("\n");
        }
        if (!descriptionSb.toString().isEmpty()) {
            missingUnitsDescriptions.append("Missing Description for the follwing paths: \n").append(descriptionSb.toString());
        }
        if (!missingUnitsDescriptions.toString().isEmpty()) {
            throw new RuntimeException(missingUnitsDescriptions.toString());
        }
    }
}

