/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.ConcurrentCallException;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.SDOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSOnlineClamp;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEventListener;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenProxy
implements BridgeToHardware,
HasLifecycle,
AlertRaiser,
CanOpenEventListener {
    private static final long PDO_TIMEOUT = 40L;
    @LookupField(strategy=LookupField.Strategy.TOP)
    public Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected CanOpenInterface canInterface;
    protected int master = 1;
    @ConfigurationParameter(description="CANbus rate.", units="unitless", category="canbus")
    volatile String baud = "1m";
    @ConfigurationParameter(description="CANbus name. Can be 0 for changer or 1 for loader.", units="unitless", category="canbus")
    volatile String busName = "0";
    @ConfigurationParameter(range="0..255", description="CANbus master nodeID.", units="unitless", category="canbus")
    volatile int masterNodeID = 8;
    @ConfigurationParameter(range="1000..100000", description="A timeout for the hardware booting process", units="millisecond", category="canbus")
    public volatile long hardwareBootTimeout = 5000L;
    protected final Map<Integer, PieceOfHardware> hardwareMapByNodeID = new HashMap<Integer, PieceOfHardware>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, PieceOfHardware> hardwareMapByName = new HashMap<String, PieceOfHardware>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, EPOSController> controllerMapByName = new HashMap<String, EPOSController>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, PlutoGateway> plutoGatewayMapByName = new HashMap<String, PlutoGateway>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    protected boolean hardwareBootProcessEnded = false;
    protected int bootedDeviceNB = 0;
    @ConfigurationParameter(description="Toggle the PDO recovery function", units="unitless", category="canbus")
    volatile boolean pdoRecoveryActive = false;
    private PDOData pdoData = new PDOData();
    private ArrayList<Integer> pdoList = new ArrayList(20);
    protected boolean canbusConnected = false;
    private ScheduledFuture<?> checkDevicesHandle;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    private final Lock lock = new ReentrantLock();
    private final Condition bootingCompleted = this.lock.newCondition();
    private AtomicLong lastUpdatePDOData = new AtomicLong(0L);

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public boolean isCanbusConnected() {
        return this.canbusConnected;
    }

    public CanOpenInterface getCanInterface() {
        return this.canInterface;
    }

    @Override
    public PDOData getPDOData() {
        return this.pdoData;
    }

    public void init() {
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.name, (Serializable)Integer.valueOf(this.bootedDeviceNB)));
        DataProviderInfo info = this.dataProviderDictionaryService.getDataProviderDictionary().getDataProviderInfoForPath(this.name);
        info.addAttribute(DataProviderInfo.Attribute.UNITS, "unitless");
        info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Booted device ID");
        this.initialize();
        this.hardwareMapByName.values().stream().forEach(poh -> this.hardwareMapByNodeID.put(poh.getNodeID(), (PieceOfHardware)poh));
        FCSLOG.info(this.name + ": init MODULE CanOpenProxy.");
        FCSLOG.info(this.name + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + this.hardwareMapByName.size());
        FCSLOG.info(this.toString());
        CanOpenErrorsTable.loadCanOpenErrorTables();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        ClearAlertHandler neverClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.UNSYNC_BOOT.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CAN_BUS_NOT_INITIALIZED.getAlert(), neverClear);
        this.hardwareMapByNodeID.values().stream().forEach(poh -> {
            this.alertService.registerAlert(FcsEnumerations.FcsAlert.BAD_SERIAL_NB.getAlert(poh.getName()), alwaysClear);
            this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_MISSING.getAlert(poh.getName()), alwaysClear);
            this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(poh.getName()), alwaysClear);
            this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(poh.getName()), alwaysClear);
        });
    }

    protected void initialize() {
        this.bootedDeviceNB = 0;
        this.hardwareBootProcessEnded = false;
        this.hardwareMapByName.values().stream().forEach(poh -> poh.setBooted(false));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Check if all pieces of hardware are booted with the correct serial number.")
    public void bootProcess() {
        FCSLOG.info(this.name + ": BEGIN OF HARDWARE BOOTING PROCESS");
        this.initialize();
        ((AgentStateService)this.subs.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAN_DEVICES_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.lock.lock();
        try {
            this.readDevicesInfo();
            this.waitForEndOfBooting();
        }
        catch (Exception ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " ERROR during hardware booting process due to " + ex, this.name);
        }
        finally {
            FCSLOG.finer(() -> this.name + ": finally in bootProcess");
            this.hardwareBootProcessEnded = true;
            this.bootingCompleted.signalAll();
            this.lock.unlock();
        }
        if (this.bootedDeviceNB == this.hardwareMapByName.size()) {
            FCSLOG.info(this.name + " ALL HARDWARE is booted");
            ((AgentStateService)this.subs.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY});
        } else if (this.bootedDeviceNB == 0) {
            FCSLOG.severe(this.name + " NO HARDWARE is booted");
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " NO HARDWARE booted - Power failure ?", this.name);
        } else if (this.bootedDeviceNB < this.hardwareMapByName.size()) {
            FCSLOG.severe(this.name + " SOME HARDWARE is MISSING");
            this.hardwareMapByName.values().stream().forEach(poh -> poh.raiseAlarmIfMissing());
        } else {
            FCSLOG.severe(this.name + " this.bootedDeviceNB =  hardwareMapByName.size() = " + this.hardwareMapByName.size());
        }
        FCSLOG.info(this.name + " BOOTED HARDWARE=" + this.listBootedNodes());
        FCSLOG.info(this.name + ": END OF HARDWARE BOOTING PROCESS");
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Initialize received PDOs list from canInterface.")
    public void initializePDOs() {
        this.hardwareMapByNodeID.values().stream().forEach(poh -> {
            try {
                poh.initializePDOs();
            }
            catch (DriverException ex) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " ERROR during PDO initialization : could not addReceivedPDOs", poh.getName(), (Exception)((Object)ex));
            }
        });
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Print pdoData for tests")
    public String printPdoData() throws DriverException {
        return this.canInterface.sync().toString();
    }

    @Override
    public void updatePDOData() {
        long duration;
        long beginTime = System.currentTimeMillis();
        if (!FcsUtils.isSimu() && beginTime - this.lastUpdatePDOData.get() < 100L) {
            return;
        }
        this.lastUpdatePDOData.set(beginTime);
        try {
            this.pdoData = this.canInterface.sync();
            FCSLOG.finer(() -> this.name + " pdoData = " + this.pdoData.toString());
            duration = System.currentTimeMillis() - beginTime;
            FCSLOG.finer(() -> this.name + " this.canInterface.sync() duration = " + duration);
        }
        catch (ConcurrentCallException ex) {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR, " couldn't update PDOs because " + ex, this.name);
        }
        catch (DriverException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " couldn't update PDOs", (Exception)((Object)ex));
        }
        if (!this.pdoData.isComplete()) {
            FCSLOG.info(this.name + "CANBUS READING ERROR : some PDOs are missing.");
            this.raiseWarningOnlyEveryTenMinutes(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR, " some PDOs are missing. Clean Power failure or bad configuration of a device ? If case of a Clean Power failure, please restart fcs. ", this.name);
            if (this.pdoRecoveryActive) {
                this.recoveryPDOMissing();
            }
            this.checkControllerAndUpdateHomingForOnlineClamps();
        }
        this.hardwareMapByNodeID.values().stream().forEach(poh -> poh.updateFromPDO(this.pdoData));
        duration = System.currentTimeMillis() - beginTime;
        FCSLOG.finer(() -> this.name + " updatePDOData duration = " + duration);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="This command may be used to recover after a clean power shutdown. But the best solution is to restart fcs.")
    public void recoveryPDOMissing() {
        FCSLOG.info(this.name + " sending command scan to put all devices in state NMT Operational.");
        try {
            this.canInterface.scan();
            FcsUtils.sleep(20, this.name);
            this.pdoData = this.canInterface.sync();
        }
        catch (DriverException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " couldn't recover missing PDOs; try to restart the fcs", (Exception)((Object)ex));
        }
    }

    public void start() {
        ((AgentStateService)this.subs.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.WAITING_FOR_HARDWARE_BOOTING, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.connectToCANbus();
    }

    public void setPDOTimeout() throws DriverException {
        this.canInterface.setPdoTimeout(40L);
    }

    public void connectToCANbus() {
        FCSLOG.info(this.name + " connecting to CANbus. " + this.toString());
        try {
            for (int nodeID : this.hardwareMapByNodeID.keySet()) {
                this.canInterface.addSlave(nodeID);
            }
            this.canInterface.init(this.master, this.baud, this.busName, this.masterNodeID);
            this.setPDOTimeout();
            this.canbusConnected = true;
            FCSLOG.info(this.name + " canbusConnected= " + this.canbusConnected + " baud=" + this.baud);
        }
        catch (DriverException ex) {
            String msg = this.name + " could not init canInterface " + this.toString();
            this.raiseAlarm(FcsEnumerations.FcsAlert.CAN_BUS_NOT_INITIALIZED, msg, (Exception)((Object)ex));
        }
        try {
            if (this.hardwareMapByNodeID.containsKey(42)) {
                this.doDisableOperation(42);
            }
            if (this.hardwareMapByNodeID.containsKey(44)) {
                this.doDisableOperation(44);
            }
            FcsUtils.sleep(100, this.name);
        }
        catch (DriverTimeoutException ex) {
            String msg = this.name + " could not disableOperation for autochanger trucks controllers after 2 tries; canbus0 is no more reachable; try reboot pc104.";
            FCSLOG.log(Level.SEVERE, msg, ex);
            this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, msg, (Exception)((Object)ex));
        }
        catch (DriverException ex) {
            String msg = this.name + " could not disableOperation for autochanger trucks controllers after 2 tries; check 24V clean or other failure for autochanger trucks controllers ? ";
            FCSLOG.log(Level.SEVERE, msg, ex);
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, msg, (Exception)((Object)ex));
        }
    }

    public void doDisableOperation(int nodeID) throws DriverException {
        try {
            this.canInterface.wsdo(nodeID, 24640, 0, 2, 7L);
            FCSLOG.info(this.name + " disableOperation DONE for nodeID = 0x" + Integer.toHexString(nodeID));
        }
        catch (DriverTimeoutException ex) {
            FCSLOG.log(Level.SEVERE, this.name + " 2nd try to disableOperation for nodeID = 0x" + Integer.toHexString(nodeID), ex);
            this.canInterface.wsdo(nodeID, 24640, 0, 2, 7L);
            FCSLOG.info(this.name + "  at 2nd try disableOperation DONE for nodeID = 0x" + Integer.toHexString(nodeID));
        }
        catch (DriverException ex) {
            String msg = this.name + " could not disableOperation for nodeID = 0x" + Integer.toHexString(nodeID);
            FCSLOG.log(Level.SEVERE, msg, ex);
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, msg, (Exception)((Object)ex));
        }
    }

    public void postStart() {
        FCSLOG.info(this.name + " BEGIN postStart");
        this.bootProcess();
        this.initializePDOs();
        this.publishData();
        FCSLOG.info(this.name + " END postStart");
    }

    public void readDevicesInfo() {
        long startTime = System.currentTimeMillis();
        Runnable checkDevices = () -> {
            try {
                long duration = System.currentTimeMillis() - startTime;
                FCSLOG.fine(() -> "duration=" + duration + " : " + this.bootedDeviceNB + " booted devices.");
                if (duration > this.hardwareBootTimeout || this.bootedDeviceNB == this.hardwareMapByName.size()) {
                    this.hardwareBootProcessEnded = true;
                    this.cancelReadDevicesInfo();
                }
                this.retrieveHardwareInfo();
            }
            catch (Exception ex) {
                FCSLOG.log(Level.SEVERE, this.name + " error in devices boot process", ex);
            }
        };
        this.checkDevicesHandle = this.scheduler.scheduleWithFixedDelay(checkDevices, 500L, 250L, TimeUnit.MILLISECONDS);
    }

    private void cancelReadDevicesInfo() {
        this.lock.lock();
        try {
            FCSLOG.finer(() -> this.name + " => stop waiting for devices info.");
            this.bootingCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.checkDevicesHandle.cancel(true);
        FCSLOG.finer(() -> this.name + " => readDevicesInfo canceled");
    }

    private void waitForEndOfBooting() {
        while (!this.hardwareBootProcessEnded) {
            try {
                FCSLOG.info(this.name + " waiting until all pieces of hardware are booted.");
                this.bootingCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSLOG.info(this.name + ": InterruptedException received=" + ex);
                break;
            }
        }
        FCSLOG.info(this.name + " STOP WAITING FOR END OF BOOTING PROCESS");
    }

    public void shutdown() {
        List taskNames = ((AgentPeriodicTaskService)this.subs.getAgentService(AgentPeriodicTaskService.class)).getAgentPeriodicTaskNames();
        if (taskNames.contains("monitor-update")) {
            ((AgentPeriodicTaskService)this.subs.getAgentService(AgentPeriodicTaskService.class)).setPeriodicTaskPeriod("monitor-update", Duration.ofSeconds(-1L));
        }
        if (taskNames.contains("monitorCurrent")) {
            ((AgentPeriodicTaskService)this.subs.getAgentService(AgentPeriodicTaskService.class)).setPeriodicTaskPeriod("monitorCurrent", Duration.ofSeconds(-1L));
        }
    }

    @Override
    public void doShutdown() {
        FCSLOG.info(this.name + " is shutting down.");
        this.scheduler.shutdown();
        try {
            FCSLOG.info(this.name + " canInterface quit.");
            this.canInterface.quit();
            ((AgentStateService)this.subs.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.OFF_LINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        }
        catch (DriverException ex) {
            FCSLOG.log(Level.SEVERE, this.name + "cannot shut down properly", ex);
        }
        FCSLOG.info(this.name + " is shut down.");
    }

    public String getNodeName(int aNodeID) {
        if (this.hardwareMapByNodeID.get(aNodeID) == null) {
            return "UnknownDevice" + aNodeID;
        }
        return this.hardwareMapByNodeID.get(aNodeID).getName();
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Print the list of CANopen nodes which are booted on the CAN bus.")
    public String listBootedNodes() {
        if (this.bootedDeviceNB == 0) {
            return this.name + ": no booted CANopen devices.";
        }
        StringBuilder sb = new StringBuilder();
        for (PieceOfHardware poh : this.hardwareMapByName.values()) {
            if (!poh.isBooted()) continue;
            sb.append("\n==>");
            sb.append(poh);
        }
        return sb.toString();
    }

    public void checkNodeID(int nodeID) {
        if (!this.hardwareMapByNodeID.containsKey(nodeID)) {
            throw new IllegalArgumentException(nodeID + " is not in the hardware list for tcpProxy " + this.name);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen writeSDO command to the CANBus. size represents the number of bytes on which the value is encoded. See device documentation.")
    public void writeSDO(int nodeID, int index, int subindex, int size, long value) {
        this.checkNodeID(nodeID);
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        this.doWriteSDO(nodeID, index, subindex, size, value);
    }

    private void doWriteSDO(int nodeID, int index, int subindex, int size, long value) {
        try {
            this.canInterface.wsdo(nodeID, index, subindex, size, value);
        }
        catch (SDOException ex) {
            String deviceName = this.getNodeName(nodeID);
            String abortName = CanOpenErrorsTable.getCanopenSDOErrorNameByCode(ex.getAbortCode());
            String msg = this.name + String.format(" error for request writeSDO for %s abortName=%s %s", deviceName, abortName, ex.toString());
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
        catch (DriverException ex) {
            String deviceName = this.getNodeName(nodeID);
            String msg = this.name + String.format(" error for request writeSDO for %s nodeID=0x%s(%d),index=0x%s,subindex=0x%s,size=%d,,value=%d", deviceName, Integer.toHexString(nodeID), nodeID, Integer.toHexString(index), Integer.toHexString(subindex), size, value);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Send a CanOpen readSDO command to the CANBus.")
    public long readSDO(int nodeID, int index, int subindex) {
        this.checkNodeID(nodeID);
        return this.doReadSDO(nodeID, index, subindex);
    }

    private long doReadSDO(int nodeID, int index, int subindex) {
        try {
            return this.canInterface.rsdo(nodeID, index, subindex);
        }
        catch (SDOException ex) {
            String deviceName = this.getNodeName(nodeID);
            String abortName = CanOpenErrorsTable.getCanopenSDOErrorNameByCode(ex.getAbortCode());
            String msg = this.name + String.format(" error for request readSDO for %s abortName=%s %s", deviceName, abortName, ex.toString());
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
        catch (DriverException ex) {
            String deviceName = this.getNodeName(nodeID);
            String msg = this.name + String.format(" error for request readSDO for %s nodeID=0x%s(%d),index=0x%s,subindex=0x%s", deviceName, Integer.toHexString(nodeID), nodeID, Integer.toHexString(index), Integer.toHexString(subindex));
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Send a command sync to CAN bus to read sensors by PDO.")
    public PDOData sync() throws DriverException {
        PDOData pdoD = this.canInterface.sync();
        FCSLOG.fine("PDOData=" + pdoD.toString());
        return pdoD;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description=" init CAN interface.")
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        this.canInterface.init(master, baud, busName, nodeID);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Add a received PDO to canInterface.")
    public void addReceivedPDO(int cobId) throws DriverException {
        FCSLOG.info(this.name + " add PDO cobId = 0x" + Integer.toHexString(cobId));
        this.canInterface.addReceivedPDO(cobId);
        this.pdoList.add(cobId);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Clear the received PDOs list from canInterface. This action is quite destructive and will need to initialise again the pdoList from the interface using addReceivedPDO according to the PDOs sent by the controller. Use only when resizing the PDO list within FCS for testing purposes before writing the proper changes to initializePDOs.")
    public void clearReceivedPDOs() throws DriverException {
        this.canInterface.clearReceivedPDOs();
        this.pdoList.clear();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Add a slave nodeId. Only for debug.")
    public void addSlave(int nodeId) {
        this.canInterface.addSlave(nodeId);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Return when was seen last heartbeat for nodeId.")
    public Instant getLastBeat(int id) {
        return this.canInterface.getLastBeat(id);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Return last state for nodeId.")
    public int getLastState(int nodeId) {
        return this.canInterface.getLastState(nodeId);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Return list of registered PDOs.")
    public Set<Integer> getRegisteredPDOs() {
        return this.canInterface.getRegisteredPDOs();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Scan CAN bus.")
    public int scan() throws DriverException {
        return this.canInterface.scan();
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, level=3, description="Reset a slave on CAN bus.")
    public void reset(int nodeId) throws DriverException {
        this.canInterface.resetNode(nodeId);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Reset a controller on CAN bus.")
    public void sendNMTResetNode(int nodeId) throws DriverException {
        this.canInterface.sendNMTResetNode(nodeId);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Reset a controller communication on CAN bus.")
    public void sendNMTResetComm(int nodeId) throws DriverException {
        this.canInterface.sendNMTResetComm(nodeId);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Retrieve device information as serial number, device vendor, device type.")
    public String info(int nodeID) throws DriverException {
        if (this.hardwareMapByNodeID.containsKey(nodeID)) {
            String result = this.findInfo(nodeID);
            FCSLOG.info("result = " + result);
            return result;
        }
        throw new IllegalArgumentException(nodeID + " (0x" + Integer.toHexString(nodeID) + ") : no such nodeID in subsystem " + this.subs.getName());
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a command quit to canInterface to device.")
    public void quit() throws DriverException {
        this.canInterface.quit();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a command setNMTStateOperational to canInterface to device.")
    public void setNMTStateOperational(int nodeID) throws DriverException {
        this.canInterface.setNMTStateOperational(nodeID);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Stop a slave on CAN bus.")
    public void setNMTStateStop(int nodeId) throws DriverException {
        this.canInterface.setNMTStateStop(nodeId);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a command setNMTStatePreOperational to canInterface to device.")
    public void setNMTStatePreOperational(int nodeID) throws DriverException {
        this.canInterface.setNMTStatePreOperational(nodeID);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Identification of the hardware: we want to retrieve the information stored in the hardware of the CANopen devices")
    public void retrieveHardwareInfo() {
        FCSLOG.info(this.name + ": Identification of the hardware");
        this.hardwareMapByName.values().stream().filter(poh -> !poh.isBooted()).forEach(poh -> this.updateDeviceInfo((PieceOfHardware)poh));
        this.publishData();
    }

    protected synchronized void updateDeviceInfo(PieceOfHardware poh) {
        int nodeID = poh.getNodeID();
        String commandInfo = "info," + Integer.toHexString(nodeID);
        try {
            if (this.isAccelero(poh) && !FcsUtils.isSimu()) {
                FCSLOG.info(poh.getName() + " is booted");
                poh.setBooted(true);
                poh.initializeAndCheckHardware();
                ++this.bootedDeviceNB;
            } else {
                String result = this.findInfo(nodeID);
                FCSLOG.info("result=" + result);
                this.processInfoMessage(poh, result);
            }
        }
        catch (DriverException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_MISSING, " no response to command: " + commandInfo + " ", poh.getName(), (Exception)((Object)ex));
        }
        catch (FcsHardwareException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " Error in boot process for device.", poh.getName(), (Exception)((Object)ex));
        }
    }

    private boolean isAccelero(PieceOfHardware poh) {
        return 80 == poh.getNodeID() && 131476 == poh.readDeviceType();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all CANopen devices are booted and identified.")
    public boolean allDevicesBooted() {
        return this.hardwareBootProcessEnded && this.bootedDeviceNB == this.hardwareMapByNodeID.size();
    }

    @Override
    public void onBootMessage(int nodeID) {
        if (this.hardwareMapByNodeID.containsKey(nodeID)) {
            PieceOfHardware poh = this.hardwareMapByNodeID.get(nodeID);
            if (poh.isBooted() && this.hardwareBootProcessEnded) {
                String cause = " received an asynchronous boot message for node ID = " + Integer.toHexString(nodeID) + " Has the device been reset or powered on ?";
                this.raiseWarning(FcsEnumerations.FcsAlert.UNSYNC_BOOT, cause, poh.getName());
            } else {
                FCSLOG.info(String.format("Received a BOOT message from poh nodeID=%d/0x%s name=%s", nodeID, Integer.toHexString(nodeID), poh.getName()));
                this.updateDeviceInfo(poh);
            }
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.UNSYNC_BOOT, Integer.toHexString(nodeID) + ":UNKNOWN device. This device is not in the hardware list.");
        }
    }

    @Override
    public void onEmergencyMessage(int nodeID, int errCode, int errReg) {
        String deviceErrorName = CanOpenErrorsTable.getDeviceErrorNameByCode(errCode);
        String errorRegisterName = CanOpenErrorsTable.getErrorRegisterNameByCode(errReg);
        String deviceName = this.getNodeName(nodeID);
        EmergencyMessage emcyMsg = new EmergencyMessage(nodeID, deviceName, errCode, deviceErrorName, errReg, errorRegisterName);
        PieceOfHardware poh = this.hardwareMapByNodeID.get(nodeID);
        if (poh != null) {
            this.subs.getScheduler().schedule(() -> poh.onEmergencyMessage(emcyMsg), 0L, TimeUnit.SECONDS);
        }
        FCSLOG.info(this.name + " received EMERGENCY message=" + emcyMsg.toString() + " for nodeID=0x" + Integer.toHexString(nodeID));
    }

    void processInfoMessage(PieceOfHardware poh, String message) {
        String[] words = message.split(", ", -1);
        String type = words[2];
        String vendor = words[3];
        String productCode = words[4];
        String revision = words[5];
        String serialNB = words[6];
        FCSLOG.info(this.name + "/" + poh.getName() + " informations read on device: type=" + type + " vendor=" + vendor + " product code=" + productCode + " revision=" + revision + " serialNB=" + serialNB);
        boolean isSenecaDevice = "249".equals(vendor);
        if (isSenecaDevice) {
            FCSLOG.info(this.name + "/found a seneca device in message: " + message);
        }
        if (poh.getSerialNB().equals(serialNB) || isSenecaDevice) {
            if (!poh.isBooted()) {
                poh.setBooted(true);
                ++this.bootedDeviceNB;
            }
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.BAD_SERIAL_NB, " serial number read on device=" + serialNB + " ==>serial number expected=" + poh.getSerialNB() + " ==>device configuration=" + poh, poh.getName());
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware expected in this subsystem.")
    public String printHardwareList() {
        return this.hardwareMapByName.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with the initialization state.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name + " CANopen devices : {");
        for (PieceOfHardware poh : this.hardwareMapByNodeID.values()) {
            sb.append(poh.printState());
            sb.append(";\n");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return an Array containing hardware names handled by this component.")
    public List<String> listHardwareNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (PieceOfHardware pieceOfHardware : this.hardwareMapByName.values()) {
            res.add(pieceOfHardware.getName());
        }
        Collections.sort(res);
        return res;
    }

    @Override
    public List<String> listAcSensorsNames() {
        if (this.plutoGatewayMapByName.containsKey("acSensorsGateway")) {
            return this.plutoGatewayMapByName.get("acSensorsGateway").listMySensorsNames();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listLoSensorsNames() {
        if (this.plutoGatewayMapByName.containsKey("loaderPlutoGateway")) {
            return this.plutoGatewayMapByName.get("loaderPlutoGateway").listMySensorsNames();
        }
        return Collections.emptyList();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return a list of pdo recorded by this CanOpenProxy")
    public String printPDOList() {
        StringBuilder sb = new StringBuilder("Number of Received PDO = ");
        sb.append(this.pdoList.size());
        this.pdoList.forEach(cobid -> {
            sb.append("; cobid = 0x");
            sb.append(Integer.toHexString(cobid));
            sb.append(this.displayCobid((int)cobid));
        });
        return sb.toString();
    }

    private String displayCobid(int cobid) {
        int[] prefixes;
        StringBuilder sb = new StringBuilder();
        for (int p : prefixes = new int[]{384, 640, 1152, 896}) {
            int nodeid = cobid - p;
            if (!this.hardwareMapByNodeID.containsKey(p)) continue;
            sb.append(" = 0x");
            sb.append(Integer.toHexString(p));
            sb.append(" + (nodeID) 0x");
            sb.append(Integer.toHexString(nodeid));
            break;
        }
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish booting information for all CANopen devices.")
    public void publishData() {
        FCSLOG.fine(this.name + " is publishing: " + this.bootedDeviceNB + " booted device(s).");
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)Integer.valueOf(this.bootedDeviceNB)));
        this.hardwareMapByName.values().stream().forEach(device -> device.publishData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(this.name);
        sb.append(" hardwareBootTimeout=");
        sb.append(this.hardwareBootTimeout);
        sb.append(" master=");
        sb.append(this.master);
        sb.append(" baud=");
        sb.append(this.baud);
        sb.append(" busName=");
        sb.append(this.busName);
        sb.append(" masterNodeID=");
        sb.append(this.masterNodeID);
        return sb.toString();
    }

    @Override
    public boolean isReady() {
        try {
            return this.canInterface.isReady() && this.allDevicesBooted();
        }
        catch (DriverException ex) {
            FCSLOG.log(Level.SEVERE, this.getClass().getName() + "isReady", ex);
            return false;
        }
    }

    @Override
    public AlertService getAlertService() {
        return (AlertService)this.subs.getAgentService(AlertService.class);
    }

    @Override
    public void connectHardware() {
    }

    @Override
    public void disconnectHardware() {
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Perform a check fault on all booted EPOS controllers")
    public void checkControllers() {
        this.controllerMapByName.values().stream().filter(epos -> epos.isBooted()).filter(epos -> !epos.isBooted()).forEach(epos -> epos.checkFault());
    }

    public void resetHomingForOnlineClampsControllers() {
        this.controllerMapByName.values().stream().filter(epos -> epos instanceof CanOpenEPOSOnlineClamp).forEach(epos -> ((CanOpenEPOSOnlineClamp)epos).resetHoming());
    }

    public void checkControllerAndUpdateHomingForOnlineClamps() {
        this.controllerMapByName.values().stream().filter(epos -> epos instanceof CanOpenEPOSOnlineClamp).forEach(epos -> ((CanOpenEPOSOnlineClamp)epos).updateHomingFromControllerStatusWord());
    }

    public String findInfo(int nodeID) throws DriverException {
        if (this.canInterface instanceof SimuCanOpenInterface || FcsUtils.isSimu()) {
            return this.findInfoSimulation(nodeID);
        }
        return this.findInfoNonSimulation(nodeID);
    }

    private String findInfoSimulation(int nodeID) {
        StringBuilder result = new StringBuilder("");
        String serialNb = this.hardwareMapByNodeID.get(nodeID).getSerialNB();
        result.append("info, ").append(Integer.toHexString(nodeID)).append(", ").append(", ").append(", ").append(", ").append(", ").append(serialNb);
        return result.toString();
    }

    private String findInfoNonSimulation(int nodeID) throws DriverException {
        StringBuilder result = new StringBuilder("");
        long deviceType = this.canInterface.rsdo(nodeID, 4096, 0);
        long vendorID = this.canInterface.rsdo(nodeID, 4120, 1);
        long productCode = this.canInterface.rsdo(nodeID, 4120, 2);
        long revNumber = this.canInterface.rsdo(nodeID, 4120, 3);
        long serialNb = this.canInterface.rsdo(nodeID, 4120, 4);
        result.append("info, ").append(Integer.toHexString(nodeID)).append(", ").append(Long.toHexString(deviceType)).append(", ").append(Long.toHexString(vendorID)).append(", ").append(Long.toHexString(productCode)).append(", ").append(Long.toHexString(revNumber)).append(", ").append(Long.toHexString(serialNb));
        return result.toString();
    }

    @Override
    public void resetCommunication(int nodeID) {
        try {
            FCSLOG.info(this.name + "Sending an NMT Reset Comm to device with nodeID " + nodeID);
            this.sendNMTResetComm(nodeID);
        }
        catch (DriverException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Unable to communicate with device with nodeID = " + nodeID, (Exception)((Object)ex));
        }
        FCSLOG.info(this.name + "NMT Reset Comm successfully sent to device with nodeID " + nodeID);
    }
}

